@extends('layouts.master')
 
@section('title') Create User @stop
 
@section('content')
 
<div class='col-lg-max col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i> Nouvel utilisateur</h1>
 
    {!! Form::open(['role' => 'form', 'url' => '/acces/users','class' => 'form-horizontal']) !!}
 

    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('prenom', 'Prenom') !!}
        {!! Form::text('prenom', null, ['placeholder' => 'Prenom', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('nom', 'Nom') !!}
        {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-2">
        {!! Form::label('login', 'Identifiant') !!}
        {!! Form::text('login', null, ['placeholder' => 'Login', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-6">
        {!! Form::label('email', 'Email') !!}
        {!! Form::email('email', null, ['placeholder' => 'Email', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('password', 'Mot de passe') !!}
        {!! Form::password('password', ['placeholder' => 'Mot de passe'
            , 'class' => 'form-control']) !!}
        </div>
    </div>
 

 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
 
    {!! Form::close() !!}
 
</div>
 
@stop