@extends('layouts.master')
 
@section('title') Mise à jour Utilisateur @stop
 
@section('content')
 
<div class='col-lg-max col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i> Mise à jour d'un utilisateur</h1>
 
    {!! Form::model($user, ['users' => 'form', 'url' => '/acces/users/' . $user->id, 'method' => 'PUT'
    , 'class' => 'form-horizontal']) !!}
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('prenom', 'Prenom') !!}
        {!! Form::text('prenom', null, ['placeholder' => 'Prenom', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('nom', 'Nom') !!}
        {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-3">
        {!! Form::label('login', 'Identifiant') !!}
        {!! Form::text('login', null, ['placeholder' => 'Login', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-6">
        {!! Form::label('email', 'Email') !!}
        {!! Form::email('email', null, ['placeholder' => 'Email', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-6">
        {!! Form::label('password', 'Mot de passe') !!}<small><i>&nbsp;&nbsp;(ne saisir que pour changer)</i></small>
        {!! Form::password('password', ['placeholder' => '*****', 'class' => 'form-control']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-md-6">
            {!! Form::label('change_pwd', 'Changer à la prochaine connexion : ') !!}
            {!! Form::checkbox('change_pwd', null, ['class' => 'form-control']) !!}
        </div>
    </div>
 


    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('roles', 'Rôles') !!}
        <br/>
            {!! Form::select(
                'users_role[]',
                $liste_roles,
                $t_getroles,
                [
                    'class' => 'selectpicker',
                    'multiple'=> 'multiple',
                ]
            ) 

            !!}
        </div>
    </div>
 
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>

    {!! Form::close() !!}
 
</div>
 
@stop