@include('forms.fbncheader')
@include('forms.fdatatables')


<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-users"></i>Administration des utilisateurs</h1>
 
    <div class="table-responsive">
        <table id="_table" class="table">
 
            <thead>
                <tr>
                    <th >Nom</th>
                    <th width='10%'>Identifiant</th>
                    <th width='10%'>Email</th>
                    <th width='10%'>Rôles</th>
                    <th width='10%'>Dernière connexion</th>
                    <th width='185px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($users as $user)
                <tr>
                    <td>
                        <a href="{!! url('/acces/users/'.$user->id) !!}" >{!! $user->full_name !!}</a></td>
                    <td nowrap>{!! $user->login !!}</td>
                    <td nowrap>{!! $user->email !!}</td>
                    <td nowrap>{!! $user->getroles() !!}</td>
                    <td nowrap>{!! $user->last_connection !!}</td>
                    <td nowrap>
                        @if($user_actif->can("USR_MAJ") || $user_actif->hasrole("ADMINISTRATEUR"))
                        <a href="./users/{!! $user->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        @endif
                        @if( 
                            ($user_actif->can("USR_SUP") || $user_actif->hasrole("ADMINISTRATEUR")) 
                            &&
                            (!$user->hasrole("ADMINISTRATEUR")) && ($user->getroles()=="")
                        )
                        {!! Form::open(['url' => '/acces/users/delete/' . $user->id, 'method' => 'DELETE']) !!}
                        {!! Form::submit('Supprimer', ['class' => 'btn btn-danger']) !!}
                        {!! Form::close() !!}
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
 
 @if($user_actif->can("USR_AJO") || $user_actif->hasrole("ADMINISTRATEUR"))
    <a href="./users/create" class="btn btn-success">Ajouter un utilisateur</a>
 @endif
</div>


@include('forms.fdatatables_script')



</body></html>