@extends('layouts.master')
 
@section('title') Détail d'un utilisateur @stop

@section('styles')
    <!-- FancyBox -->
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
@stop

@section('content')
 
<div class='col-lg-10 col-lg-offset-1'>
 
    <h1><i class='fa fa-user'></i> Détail d'un utilisateur</h1>
 
    {!! Form::model($user, ['users' => 'form','class' => 'form-horizontal']) !!}
 
    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('prenom', 'Prenom') !!}
        {!! Form::text('prenom', null, ['readonly', 'class' => 'form-control text-uppercase']) !!}
        </div>

        <div class="col-xs-4">
        {!! Form::label('nom', 'Nom') !!}
        {!! Form::text('nom', null, ['readonly', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-3">
        {!! Form::label('login', 'Identifiant') !!}
        {!! Form::text('login', null, ['readonly', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>
 
    <div class='form-group'>
        <div class="col-xs-6">
        {!! Form::label('email', 'Email') !!}
        {!! Form::email('email', null, ['readonly', 'class' => 'form-control text-lowercase']) !!}
        </div>
    </div>

 


    <div class='form-group'>
        <div class="col-xs-4">
        {!! Form::label('roles', 'Rôles') !!}
        <br/>
            {!! Form::select(
                'users_role[]',
                $liste_roles,
                DB::table('role_user')->where('user_id', '=', $user->id)->pluck("role_id")->toArray(),
                [
                    'class' => 'selectpicker',
                    'multiple'=> 'multiple',
                    'readonly'
                ]
            ) 

            !!}
        </div>
    </div>
 
 
     <div class="col-sm-9">
        <div class='form-group'><br/>
            <a href="{!! url('/acces/users') !!} ">
            {!! Form::button('Retour', ['class' => 'btn btn-warning']) !!}
            </a>

            @if($user_actif->hasrole("ADMINISTRATEUR"))
            <a href="{!! url('log_user/'.$user->id) !!} " 
                class="box_imput fancybox.iframe">
            {!! Form::button('Journal des modififcations', ['class' => 'btn btn-info']) !!}
            </a>
            @endif
        </div>
    </div>

    {!! Form::close() !!}
 
</div>
@stop 


@section('scripts_end')
    <!-- FancyBox -->
    {!! Html::script('js/jquery.fancybox.js') !!}
    <script>
        $(".box_imput").fancybox({
            width:'90%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {
                eTarget=$(this.element).attr("id");
            },
            afterClose: function () {
                if (eTarget!="btn_visu_imputation") {
                    $("#refresh").val(true);
                    $("#form").submit();
                }
                return;
            }
        });
    </script>
@stop