@include('forms.fbncheader')
@include('forms.fdatatables')



<div style=""  class="col-lg-max col-lg-offset-1 container-fluid">

<div style="padding-left:0px" class="col-lg-12">
     <h2>Salaire avec dépassement de plafond</h2>


        <div class="col-xs-2">
            {!! Form::label('annes', 'Année :' ) !!}
            {!! Form::select('annee',$annees,$annee,
                [
                    'id' => 'annee','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#annee').on('change', function() {
                        location.href="{!! url('/analyses/salaires/') !!}/"+$('#annee').val();
                    });
                });
            </script>
        </div>
</div>

<div class='col-lg-max' style="padding-top:5px">
    <div class="">
        <table id="_table" style="background-color:white" 
            class="table table-striped table-bordered table-hover" width="100%" 
            >
            <thead>
                <tr>
                        <th width='1%'>N°</th>
                        <th >Employé</th>
                        <th width='1%'>DateNais.</th>
                        <th width='1%'>Année</th>
                        <th width='1%'>DateEnt.</th>
                        <th width='1%'>DateSor</th>
                        <th >N°Emp.</th>
                        <th >Employeur</th>
                        @foreach($t_mois as $mois)
                        <th class="sum" width='5%'>{!! $mois !!}</th>
                        @endforeach
                        <th width='5%'>Der.Modif.</th>
                        <th width='1px'></th>
                </tr>
            </thead>
 
            <tbody>


                    @foreach ($salaires as $salaire)
                        @php
                            $color_histo="default";$lib_update="Modifié il y a plus de 3 mois";
                            $diff=App\Models\MyApp::getNbjDate($salaire->updated_at,date('Y-m-d'));
                            if($diff<90) {$color_histo="info";$lib_update='Modifié dans les 3 mois';}
                            if($diff<60) {$color_histo="warning";$lib_update='Modifié dans les 2 mois';}
                            if($diff<30) {$color_histo="danger";$lib_update='Modifié dans le mois';}
                        @endphp
                        <tr>
                            <td>{!! $salaire->benum !!}</td>
                            <td>
                                <a href="{!! url('tiers/beneficiaires/'.$salaire->benum) !!}" target='_blank'>
                                    {!! $salaire->beneficiaire_Nom !!}
                                </a>
                            </td>
                            <td nowrap>{!! $salaire->BeneficiaireDateNaissance !!}</td>
                            <td nowrap align='center'>{!! $salaire->annee !!}</td>
                            <td nowrap>{!! $salaire->dat_ent !!}</td>
                            <td nowrap>{!! $salaire->date_sor !!}</td>
                            <td nowrap>{!! str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT) !!}</td>
                            <td>{!! $salaire->employeur_nom !!}</td>

                            @foreach($t_mois as $mois)
                                @php
                                    $horsplafond=$salaire->getIsHorsPlafond($mois);
                                    $montant_salaire=$salaire->{$mois};
                                    $style="";
                                    if($horsplafond) $style.="color:red;";
                                    if($salaire->getSuspendu($mois)) {
                                        $style.="background-color:darkgrey;font-size:.9em";
                                        $montant_salaire="SUSPENDU";
                                    }
                                @endphp
                                <td nowrap align='right' style='{!! $style !!}'>
                                    @if($horsplafond)
                                        {!! $montant_salaire !!}
                                    @endif
                                </td>
                            @endforeach
                            <td nowrap align='right'>
                                <a title="{!! $lib_update !!}" href="{!! url('log_salaires/'.$salaire->id) !!} " 
                                    class="btn bt-sm btn-{!! $color_histo !!} box_log fancybox.iframe">
                                {!! $salaire->updated_at !!}</a>
                            </td>
                            <td nowrap>
                            @if($user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('recouvrement/salaires/'.$salaire->id .'/edit') !!}"
                                    class="btn btn-info glyphicon glyphicon-pencil"></a>
                            @endif 
                            </td>
                        </tr>
                    @endforeach


            </tbody>
        </table>
        

    </div>

</div>

</div>

</body></html>


<script>
$(document).ready(function() {
   $.fn.dataTable.moment('D/M/YYYY');

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: true,
        bInfo: true,
        bFilter: true,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,

        iDisplayLength:10,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            dom: "<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
            ],

            "aaSorting": [
                [0,'desc']
            ],

        } );





} );
</script>

