@extends('layouts.dash')

@section('content')

        @if(session()->has('error'))
             <p class="alert alert-danger">{{session('error')}}</p>
        @endif

      <div class="content mt-3">
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Changer d'Utilisateur</strong>
                            </div>

                            <div class="card-body">
                                <div class="col-lg-max col-lg-offset-1 container-fluid">
                         
                                    {!! Form::model($user, ['user' => 'form', 'url' => 'change_profil', 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
                                 
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                {!! Form::label('utilisateur', 'Utilisateur') !!}

                                                    {!! Form::select(
                                                        'user_id',
                                                        [""=>"Choisissez un utilisateur"]+$users_list,
                                                        DB::table('users')->where('id', '=', $user->id)->value("id"),
                                                        [
                                                            'class' => 'form-control selectpicker',
                                                            'data-width' => "100%"
                                                        ]
                                                    ) 
                                                !!}
                                            </div>
                                        </div>
                                    </div>

                                    <div class='form-group'>
                                            {!! Form::submit('Valider', ['class' => 'btn btn-primary']) !!}
                                    </div>

                                    {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection