@extends('layouts.master')
 
@section('title') Nouvelle écriture @stop
 
@section('content')
 
<div class='col-lg-10 col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif



<?php
 
?>

    <h1><i class='fa fa-banque'></i> Nouvelle écriture</h1>
 
    {!! Form::open(['journal' => 'form', 'url' => '/compta/journal', 'class' => 'form-horizontal']) !!}
 
    <div class='form-group'>

            <div class="col-xs-2">
                {!! Form::label('date', 'Date') !!}
                <div class='input-group date' id='datepicker_date'>
                        {!! Form::text('date', date('d/m/Y'), ['class' => 'form-control']) !!}
                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_date').datepicker({
                                format: "dd/mm/yyyy",
                                language: "fr",
                                autoclose: true
                            });
                        });
                    </script>
                </div>
            </div>
    </div>

    <div class="form-group">
        <div class="col-xs-6">
            {!! Form::label('numcpt', 'Numéro de compte') !!}
            {!! Form::hidden('numcpt', null, ['id' => 'numcpt']) !!}
            {!! Form::hidden('nomcpt', null, ['id' => 'nomcpt']) !!}

            <div class="input-group">
                <span class="input-group-addon"  id='compte_addon'>{!! old('numcpt') !!}</span>
                <input type="text" class="form-control" name="nom_compte" id="nom_compte" 
                    value="{!! old('nomcpt') !!}" 
                    placeholder="Numéro" 
                    />
            </div>


                <script type="text/javascript">
                $(function() {
                    $("#nom_compte").autocomplete({
                        source: "{!! url('auto_compte_compta') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#numcpt').val(ui.item.id);
                            var nom=ui.item.value;
                            var num=ui.item.id;
                            nom=nom.substr(nom,7);
                            $('#nom_compte').html(nom);
                            $('#nomcpt').val(nom);
                            $('#compte_addon').html(ui.item.id);
                            $('#budget').val(ui.item.budget);
                        },
                        change: function( event, ui ) {
                            var id_nom=ui.item.value.trim();
                            var nom;
                            if(id_nom.length>7) nom=(id_nom.substring(6)).trim();
                            $('#nom_compte').val(nom);
                            $('#nomcpt').val(nom);
                            $('#compte_addon').html(ui.item.id);
                            $('#numcpt').val(ui.item.id);
                        }
                    }); 



                });
            </script>
        </div>




        <div class="col-xs-3">
            {!! Form::label('budjet', 'Budget') !!}
            <div class="input-group has-warning">
                {!! Form::text('budget', null, ['id'=>'budget','class' => 'text-right form-control','readonly'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-xs-2">
        {!! Form::label('ref', 'Référence') !!}
        {!! Form::text('ref', null, ['placeholder' => 'Référence', 'class' => 'form-control']) !!}
        </div>

        <div class='col-md-7'>
        {!! Form::label('libelle', 'Libellé') !!}
        {!! Form::text('libelle', null, ['placeholder' => 'Libellé', 'class' => 'form-control']) !!}
        </div>
    </div>



<!--
    <div class="form-group">
        <div class="col-xs-2">
        {!! Form::label('enc', 'ENC') !!}
        {!! Form::text('enc', null, ['placeholder' => 'ENC', 'class' => 'form-control']) !!}
        </div>
    </div>
-->




    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-error">
                <div class="input-group-addon" style="width:100px">Débit</div>
                {!! Form::text('debit', null, ['placeholder' => 'Débit', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-success">
                <div class="input-group-addon" style="width:100px">Crédit</div>
                {!! Form::text('credit', null, ['placeholder' => 'Crédit', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


    <div class="form-group bg-warning">
        <fieldset class="alert">
            <legend>Compensation (facultatif)</legend>
            <div class="col-xs-6">
                {!! Form::label('numcpt2', 'Numéro de compte (compensation)') !!}
                {!! Form::hidden('numcpt2', null, ['id' => 'numcpt2']) !!}
                {!! Form::hidden('nomcpt2', null, ['id' => 'nomcpt2']) !!}

                <div class="input-group">
                    <span class="input-group-addon"  id='compte2_addon'>{!! old('numcpt2') !!}</span>
                    <input type="text" class="form-control" name="nom_compte2" id="nom_compte2" 
                        value="{!! old('nomcpt2') !!}"
                        placeholder="Numéro" 
                        />
                </div>

                <script type="text/javascript">
                $(function() {
                    $("#nom_compte2").autocomplete({
                        source: "{!! url('auto_compte_compta') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#numcpt2').val(ui.item.id);
                            var nom=ui.item.value;
                            var num=ui.item.id;
                            nom=nom.substr(nom,7);
                            $('#nom_compte2').html(nom);
                            $('#nomcpt2').val(nom);
                            $('#compte2_addon').html(ui.item.id);
                            $('#budget2').val(ui.item.budget);
                        },
                        change: function( event, ui ) {
                            var id_nom=ui.item.value.trim();
                            var nom;
                            if(id_nom.length>7) nom=(id_nom.substring(6)).trim();
                            $('#nom_compte2').val(nom);
                            $('#nomcpt2').val(nom);
                            $('#compte2_addon').html(ui.item.id);
                            $('#numcpt2').val(ui.item.id);
                        }
                    });    
                });
                </script>
            </div>

            <div class="col-xs-3">
                {!! Form::label('budget2', 'Budget (compensation)') !!}
                <div class="input-group has-warning">
                    {!! Form::text('budget2', null, ['id'=>'budget2','class' => 'text-right form-control','readonly'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>


        <fieldset>
    </div>


    <h1>&nbsp;</h1>

    <div class="col-sm-9">
        <div class='form-group'>
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>

    {!! Form::close() !!}
 
 </div>
 
@stop