@extends('layouts.master')
 
@section('title') Mise à jour d'un Journal  @stop
 


@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
    <!-- Datatable -->
    {!! Html::style('css/dataTables.bootstrap.css'); !!} 
    {!! Html::style('css/buttons.bootstrap.css'); !!} 
@stop


@section('content')
 
<div class='col-lg-8 col-lg-offset-2'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i>Mise à jour du Journal : <span style="color:gray">{!! $journal->id !!}</span></h1>
 
    {!! Form::model($journal, ['plan' => 'form', 'url' => '/compta/journal/' . $journal->id

        , 'class' => 'form-horizontal', 'method' => 'PUT']) !!}
  


    <div class='form-group'>

            <div class="col-xs-3">
                {!! Form::label('date', 'Date') !!}
                <div class='input-group date' id='datepicker_date'>
                        {!! Form::text('date', $journal->date, ['class' => 'form-control']) !!}
                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_date').datepicker({
                                format: "dd/mm/yyyy",
                                language: "fr",
                                autoclose: true
                            });
                        });
                    </script>
                </div>
            </div>
    </div>

    <div class="form-group">
        <div class="col-md-7">
            {!! Form::label('numcpt', 'Numéro de compte') !!}
            {!! Form::hidden('numcpt', null, ['id' => 'numcpt']) !!}

            <div class="input-group">
                <span class="input-group-addon"  id='compte_addon'>
                    {!! str_pad($journal->numcpt, 6, "0", STR_PAD_LEFT) !!}
                </span>
                <input type="text" class="form-control" name="nom_compte" id="nom_compte" 
                    value='{!! $journal->nom_compte !!}' 
                    placeholder="Numéro" 
                    />
            </div>

                <script type="text/javascript">
                $(function() {
                    $("#nom_compte").autocomplete({
                        source: "{!! url('auto_compte_compta') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#numcpt').val(ui.item.id);
                            var nom=ui.item.value;
                            var num=ui.item.id;
                            nom=nom.substr(nom,7);
                            $('#nom_compte').html(nom);
                            $('#compte_addon').html(ui.item.id);
                            $('#budjet').html(ui.item.id);
                            $('#budget_addon').val(ui.item.budget);
                        },
                        change: function( event, ui ) {
                            var id_nom=ui.item.value.trim();
                            var nom;
                            if(id_nom.length>7) nom=(id_nom.substring(6)).trim();
                            $('#nom_compte').val(nom);
                            $('#compte_addon').html(ui.item.id);
                            $('#numcpt').val(ui.item.id);
                        }
                    });    
                });
            </script>
        </div>

        <div class="col-md-3">
            {!! Form::label('budjet', 'Budget') !!}
            <div class="input-group has-warning">
                {!! Form::text('budget', null, ['id'=>'budget_addon','class' => 'text-right form-control','readonly'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-xs-2">
        {!! Form::label('ref', 'Référence') !!}
        {!! Form::text('ref', null, ['placeholder' => 'Référence', 'class' => 'form-control']) !!}
        </div>

        <div class='col-md-8'>
        {!! Form::label('libelle', 'Libellé') !!}
        {!! Form::text('libelle', null, ['placeholder' => 'Libellé', 'class' => 'form-control']) !!}
        </div>
    </div>



    <div class="form-group">
        <div class="col-xs-2">
        {!! Form::label('enc', 'ENC') !!}
        {!! Form::text('enc', null, ['placeholder' => 'ENC', 'class' => 'form-control']) !!}
        </div>
    </div>




    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-error">
                <div class="input-group-addon" style="width:100px">Débit</div>
                {!! Form::text('debit', null, ['placeholder' => 'Débit', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-success">
                <div class="input-group-addon" style="width:100px">Crédit</div>
                {!! Form::text('credit', null, ['placeholder' => 'Crédit', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


    <div class="col-sm-9">
        <div class='form-group'>
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>

    {!! Form::close() !!}
 
</div>
 
@stop



@section('scripts')
    {!! Html::script('js/magicsuggest.js') !!}
    {!! Html::script('js/jquery.fancybox.js') !!}
    

    {!! Html::script('js/moment.min.js'); !!}
    {!! Html::script('js/datetime-moment.js'); !!}

@stop

