@extends('layouts.master')
 
@section('title') Consultation d'un Compte  @stop
 
@section('content')
 
<div class='col-lg-8 col-lg-offset-2'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i>Compte {!! $plan->numcpt !!}</h1>
  
    {!! Form::model($plan, ['plan' => 'form'
        , 'url' => '', 'method' => 'GET', 'class' => 'form-horizontal']) !!}


    <div class='form-group'>
        <div class="col-md-3">
            <div class="has-success has-feedback">
                <div class="input-group">
                    <span class="input-group-addon">N°Compte</span>
                    <input readonly="readonly" type="text" class="form-control" name="numcpt" id="numcpt" 
                    value='{!! $plan->numcpt !!}' />
                </div>
           </div>
       </div>
    </div>

    <div class='form-group'>
        <div class='col-md-8'>
        {!! Form::label('nomcpt', 'Nom') !!}
        {!! Form::text('nomcpt', null, ['readonly', 'class' => 'form-control']) !!}
        </div>
    </div>

    <div class='form-group'>
        <div class="col-xs-2">
            {!! Form::label('categ', 'Compte') !!}
            {!! Form::text('categ', $plan->CategLibelle, ['readonly','class' => 'form-control']) !!}
        </div>


        <div class="col-xs-2">
            {!! Form::label('categ_bilan', 'Catég. Bilan') !!}
            {!! Form::text('categ_bilan', $plan->CategBilanLibelle, ['readonly','class' => 'form-control']) !!}
        </div>


        <div class="col-xs-4">
            {!! Form::label('categ_cr', 'Catég. Compte de Résultat') !!}
            {!! Form::text('categ_cr', $plan->CategCRLibelle, ['readonly','class' => 'form-control']) !!}
        </div>

<!--
        <div class='col-xs-2'>
                {!! Form::label('poste', 'Poste') !!}
                {!! Form::text('poste', null, ['placeholder' => 'Poste', 'class' => 'form-control']) !!}
        </div>
-->
    </div>


    <div class='form-group'> 
        <div class="col-xs-4">
            {!! Form::label('amort', 'Compte Amortisssement') !!}
            {!! 
            Form::select(
                'amort',[" "=>"Aucun"]+$comptes,
                null,
                ['class' => 'selectpicker','data-width' => "100%",'disabled']
            ) 
            !!}
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-warning">
                <div class="input-group-addon" style="width:100px">Budget</div>
                {!! Form::text('budget', null, ['readonly', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-error">
                <div class="input-group-addon" style="width:100px">Débit <i>(Calculé)</i></div>
                {!! Form::text('debit_calc', $plan->getDebitCalc(), ['readonly', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-success">
                <div class="input-group-addon" style="width:100px">Crédit <i>(Calculé)</i></div>
                {!! Form::text('credit_calc', $plan->getCreditCalc(), ['readonly', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


    <div class="col-sm-9">
        <div class='form-group'><br/>
            <a class="btn btn-warning" href="{!! url('compta/plan') !!}">
                Retour</a>

        <a href="{!! url('/compta_grandlivre').'/'.$plan->numcpt.'/'.$exercice !!}" target="_blank" class="btn btn-danger">
            Grand Livre</a>
    </div> 


    </div>

    {!! Form::close() !!}
 
</div>
 
@stop