
<script>
$(document).ready(function () {
    $(".fancybox").on("click", function (e) {
        e.preventDefault();
        fancyconfirm("Do you wish to continue?", {
            /* 
                Define your buttons here, can handle multiple buttons 
                with custom title and values
                */
            buttons: [{
                class: "yes",
                type: "button",
                title: "Yes",
                value: "yes"
            }, {
                class: "no",
                type: "button",
                title: "No",
                value: "no"
            }, {
                class: "maybe",
                type: "button",
                title: "Maybe?",
                value: "maybe"
            }],
            modal: true
        },

        function (resp) {
            alert("You clicked " + resp);
        });
    });
});

function fancyconfirm(msg, options, callback) {
    $.fancybox("#confirm", {
        modal: options.modal,
        beforeShow: function () {
            this.content.prepend("<p class=\"title\"></p>");
            $(".title").html(msg);

            if (options.buttons == null) {
                options.buttons = [{
                    clsName: "yes",
                    title: "Yes",
                    value: true
                }, {
                    clsName: "no",
                    title: "No",
                    value: false
                }];
            }

            for (i = 0; i < options.buttons.length; i++) {
                this.content.append($("<input>", {
                    type: "button",
                    class: "confirm " + options.buttons[i].class,
                    value: options.buttons[i].title
                }).data("index", i).css("margin-left", ((i > 0) ? "10px" : "")));
            }
            $(this.content).css("text-align", "center");
        },
        afterShow: function () {
            $(".confirm").on("click", function (event) {
                ret = options.buttons[$(event.target).data("index")].value;
                $.fancybox.close();
            });
        },
        afterClose: function () {
            this.content.html("");
            callback.call(this, ret);
        }
    });
}
</script>