@extends('layouts.master')
 
@section('title') Nouvelle Imputation @stop
 
@section('content')
 



<div class="container-fluid {!! (isset($mandat))?'col-lg-8':'col-lg-max col-lg-offset-1' !!}">
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Nouvelle Imputation</h1>
 
     {!! Form::open(['imputation' => 'form', 'url' => '/mandatements/imputations', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($mandat)?true:false),['id'=>'mode_frame']); !!}
    
    <div class="tab-content">
        <div class="form-group">

            <div class="col-xs-4">
                {!! Form::label('idmandat', 'Numéro de mandat') !!}
                {!! Form::text('idmandat',  (isset($mandat)?$mandat->id:null), 
                    ['placeholder' => "Numéro de mandat", 
                        isset($mandat)?'readonly':'','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-4">
                {!! Form::label('cpt_imp', 'Compte Imputation') !!}
                {!! 
                Form::select(
                    'cpt_imp',$comptes,
                    null,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) 
                !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-8">
                {!! Form::label('designation', 'Désignation') !!}
                {!! Form::textarea('designation', null, 
                    ['placeholder' => "désignation", 'rows' => '2', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-4">
                {!! Form::label('type_imp', 'Type') !!}
                {!! 
                Form::select(
                    'type_imp',
                    ['CLR'=>'CLR','CPF' => 'CPF','ASE' => 'ASE','AVI' => 'AVI','CSR' => 'CSR'],
                    null,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) 
                !!}
            </div>


            <div class="col-xs-4">
                {!! Form::label('montant', 'Montant') !!}
                {!! Form::text('montant', null, 
                    ['placeholder' => "Montant", 'class' => 'form-control']) !!}
            </div>

        </div>

        <div class='form-group'>
            <div class="col-xs-8">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>
    </div>


    <div class="col-xs-8">
        <div class='form-group'><br/>
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
    {!! Form::close() !!}



</div>
 

@stop