@extends('layouts.master')
 
@section('title') Mise à jour d'une Imputation @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Mise à jour d'une Imputation</h1>
 
    {!! Form::model($imputation, ['imputation' => 'form'
        , 'url' => '/mandatements/imputations/'. $imputation->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($mandat)?true:false),['id'=>'mode_frame']); !!}
    <div class="tab-content">

        <div class="form-group">
            <div class="col-xs-3">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='{!! str_pad($imputation->id, 5, "0", STR_PAD_LEFT) !!}' />
                    </div>
               </div>
           </div>
        </div>

        <div class="form-group">
            <div class="col-xs-5">
                {!! Form::label('cpt_imp', 'Compte Imputation') !!}
                {!! 
                Form::select(
                    'cpt_imp',$comptes,
                    null,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) 
                !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-8">
                {!! Form::label('designation', 'Désignation') !!}
                {!! Form::textarea('designation', $imputation->designation, 
                    ['placeholder' => "désignation", 'rows' => '2', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-3">
                {!! Form::label('idmandat', 'Numéro de mandat') !!}
                {!! Form::text('idmandat', $imputation->idmandat, 
                    ['placeholder' => "Numéro de mandat", 'class' => 'form-control',(isset($mandat)?'readonly':'')]) !!}
            </div>

            <div class="col-xs-3">
                {!! Form::label('type_imp', 'Type') !!}
                {!! 
                Form::select(
                    'type_imp',
                    ['CLR'=>'CLR','CPF' => 'CPF','ASE' => 'ASE','AVI' => 'AVI','CSR' => 'CSR'],
                    $imputation->type_imp,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) 
                !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('montant', 'Montant') !!}
                {!! Form::text('montant', $imputation->montant, 
                    ['placeholder' => "Montant", 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-6">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>
    </div>

    <div class="col-sm-9">

        <div class='form-group'><br/>
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
    {!! Form::close() !!}
    


</div>
 

@stop