@include('forms.fbncheader')
@include('forms.fdatatables')


<div style="background-color:rgba(0,0,139,.2);"  
    class="col-lg-max col-lg-offset-1 container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/imputations.png", 
                    "Imputations", array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                !!} 
            </div>
            <div class="col-xs-10" style="padding-left:0px;">
                <h1 style="margin-top:2px;">
                    Imputations
                </h1>
            </div>
        </div>

        <div class="row col-xs-2">
            {!! Form::label('annes', 'Années :' ) !!}
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('/mandatements/imputations_annee/') !!}/"
                            +$('#exercice_id').val();
                    });
                });
            </script>
        </div>
    </div>
    <br/>
    <div class='col-lg-max' style="padding-top:5px">
        <div class="">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1%' nowrap>Id</th>
                        <th width='1%' nowrap>N°Compte</th>
                        <th>Désignation</th>
                        <th width='1%'>Montant</th>
                        <th width='1%'>Type</th>
                        <th width='1%'>IdMandat</th>
                        <th>Observations</th>
                        <th></th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($imputations as $imputation)
                    <?php
                        $imputations=App\Models\Imputation::find($imputation->idmandat);
                    ?>
                    <tr class="clickable-row" data-href="{!! url('mandatements/imputations/'.$imputation->id) !!}">
                        <td align="center">
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('mandatements/imputations/'.$imputation->id)!!}" 
                                    class="" style="margin-right: 3px;">
                            @endif

                            {!! str_pad($imputation->id,5,'0',STR_PAD_LEFT) !!}

                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif 
                        </td>
                        <td>{!! $imputation->cpt_imp !!}</td>
                        <td>{!! $imputation->designation !!}</td>
                        <td>{!! $imputation->montant !!}</td>
                        <td>{!! $imputation->type_imp !!}</td>
                        <td>{!! $imputation->idmandat !!}</td>
                        <td>{!! $imputation->obs !!}</td>
                        <td>
                        @if($user->can("IMP_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('mandatements/imputations/'.$imputation->id.'/edit') !!}" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        @endif 
                        @if($user->can("IMP_SUP")|| $user->HasRole("ADMINISTRATEUR"))      
                            {!! Form::open(['url' => '/mandatements/imputations/' . $imputation->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                            {!! Form::close() !!}
                        @endif 
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                <script>
                jQuery(document).ready(function($) {
                    $(".clickable-row").click(function() {
                        window.document.location = $(this).data("href");
                    });
                });
                </script>
            @endif
        </div>
    @if($user->can("IMP_AJO") || $user->HasRole("ADMINISTRATEUR"))
         <div>
            <h4><a href="{!! url('mandatements/imputations/create') !!}" 
                class="btn btn-success">Ajouter une Imputation</a></h4>
        </div> 
    @endif
    </div>
</div>

</body></html>


@include('forms.fdatatables_script')