@extends('layouts.master')
 
@section('title') Consultation d'une Imputation @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Consultation d'une Imputation</h1>
 
    {!! Form::model($imputation, ['imputation' => 'form'
        , 'url' => '', 'method' => 'GET', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        <div class="form-group">
            <div class="col-md-2">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='{!! str_pad($imputation->id, 5, "0", STR_PAD_LEFT) !!}' />
                    </div>
               </div>
           </div>
        </div>

        <div class="form-group">
            <div class="col-xs-5">
                {!! Form::label('cpt_imp', 'Compte Imputation') !!}
                {!! 
                Form::select(
                    'cpt_imp',$comptes,
                    null,
                    ['class' => 'selectpicker','data-width' => "100%",'readonly'=>'readonly']
                ) 
                !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-6">
                {!! Form::label('designation', 'Désignation') !!}
                {!! Form::textarea('designation', $imputation->designation, 
                    ['readonly', 'rows' => '2', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-2">
                {!! Form::label('idmandat', 'Numéro de mandat') !!}
                {!! Form::text('idmandat', $imputation->idmandat, 
                    ['readonly', 'class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('type_imp', 'Type') !!}
                {!! 
                Form::select(
                    'type_imp',
                    ['CPS'=>'CPS','CLS' => 'CLS','ASE' => 'ASE','AVI' => 'AVI','CSR' => 'CSR'],
                    $imputation->type_imp,
                    ['class' => 'selectpicker','data-width' => "100%",'disabled']
                ) 
                !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('montant', 'Montant') !!}
                {!! Form::text('montant', $imputation->montant, 
                    ['readonly', 'class' => 'form-control']) !!}
            </div>

        </div>

        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['readonly', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>
    </div>


    @if(!$frame)
    <div class="col-sm-9">
        <div class='form-group'><br/>
            <a class="btn btn-warning" href="{!! url('mandatements/imputations') !!}">
                Retour</a>
        </div>
    </div>
    @endif
    {!! Form::close() !!}
    


</div>
 

@stop