@extends('layouts.master')
 
@section('title') Nouveau Mandat @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Nouveau Mandat</h1>
 
     {!! Form::open(['mandat' => 'form', 'url' => '/mandatements/mandats', 'class' => 'form-horizontal']) !!}


        <div class="tab-content">


            <div class="form-group">
                <div class="col-md-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::text('exercice',date('Y'), ['placeholder' => "Exercice", 'class' => 'form-control']) !!}
                </div>

                <div class="col-md-2">
                    {!! Form::label('date_sai', 'Date') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_sai'>
                            {!! Form::text('date_sai', date('d/m/Y'), ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_sai').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    {!! Form::label('statut_mdt', 'Statut') !!}
                    {!! 
                    Form::select(
                        'statut_mdt',
                        ['ANN'=>'Annulé','ENC' => 'En-cours','REJ' => 'Rejeté','VAL' => 'Validé'],
                        'ENC',
                        ['class' => 'selectpicker','data-width' => "100%"]
                    ) 
                        
                    !!}
                </div>

            <div class="col-md-2">
                    {!! Form::label('type', 'Type') !!}
                    {!! 
                    Form::select(
                        'type',
                        ['P'=>'Paiement','A' => 'Annulation'],
                        'P',
                        ['class' => 'selectpicker','data-width' => "100%"]
                    ) 
                        
                    !!}
                </div>
            </div>

            <div class='form-group'>
                <div class="col-md-6">
                {!! Form::label('observation', 'Observations') !!}
                {!! Form::textarea('observation', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
                </div>
            </div>


        <div class="col-md-8 bg-success" >  
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Directeur</i></b></legend>
                    {!! Form::label('date_valid_dir', 'Date') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid_dir'>
                            {!! Form::text('date_valid_dir',null, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid_dir').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_dir', 'Observations') !!}
                    {!! Form::textarea('observation_dir', null, ['placeholder' => 'Observations du Directeur', 'class' => 'form-control', 'rows'=>'3']) !!}
                </div>

            </div>
        </div>


        <div class="col-md-8 bg-info" >
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Comptable</b></i></legend>
                    {!! Form::label('date_valid', 'Date') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid'>
                            {!! Form::text('date_valid', null, ['alt' => 'Date de validation comptable', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_val', 'Observations') !!}
                    {!! Form::textarea('observation_val', null, ['placeholder' => 'Observations du Directeur', 'class' => 'form-control', 'rows'=>'3']) !!}
                </div>

            </div>
        </div>
    </div>

    <div class="col-sm-9">

        <div class='form-group'><br/>
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
    {!! Form::close() !!}
    


</div>
 

@stop