@extends('layouts.master')
 
@section('title') Exportation d'un mandat TP @stop
 
@section('content')
 

<div class="col-lg-10 col-lg-offset-1">

    @if(!isset($nom_file))
        <h1>{!! "Génération du fichier TP pour les mandats à transférer" !!}</h1>   
           {!! Form::open(['form' => 'generation', 
                'url' => 'mandats_export_fichier_TP', 'method' => 'POST'
                , 'class' => 'form-horizontal']) !!}
    @else

        <h1>{!! "Transmission fichier TP pour les mandats : ".$mandat_liste !!}</h1>   
           {!! Form::open(['form' => 'form', 
                'url' => 'mandat_email_fichier', 'method' => 'POST'
                , 'class' => 'form-horizontal']) !!}
    @endif


    <div class="alert col-xs-12 row bg-{!! (!isset($nom_file)?'danger':'success')!!}">
        <div class="row">
            <div class="col-xs-1">
                @if(!isset($nom_file))
                   {!! Html::image("img/process.png", "Export", 
                    array( 'maxwidth' => '30%','width' => '50%' )) !!} 
                @else
                   {!! Html::image("img/process_valide.png", "Export", 
                    array( 'maxwidth' => '30%','width' => '50%' )) !!} 
                @endif
            </div>
            <div class="col-xs-11 " align='center' style="">
                @if(!isset($nom_file))
                    <h4>Cette opération va permettre de générer un fichier destiné à la DFiP.</h4>
                    <h4>Ce fichier ne contiendra les paiements des mandat suivants :</h4>
                    @foreach($mandats as $mandat) 
                        <h4 style="margin:1px">{!! $mandat->getListeCreancierHTML_Export() !!} </h4>
                    @endforeach
                    <h4></h4>
                @else
                    <h4>
                        Le fichier a été généré. Il contient <b>{!! $nb_lignes !!} lignes</b>.
                        <br/>Vous pouvez le télécharger en faisant un <i>clique-droit</i> puis <i>enregistrer le lien sous</i> sur l'icône ci-dessous..
                    </h4>
                @endif
            </div>
        </div>

        <div class="row">
            <div class="col-xs-1">
            </div>
            <div class="col-xs-11">
                <div class="form-group" align="center">
                    @if(!isset($nom_file))
                        <div class="form-group row">
                            <div class="col-md-2"></div>
                            <div class="col-md-4">
                                    {!! Form::label('compte', 'Compte (11 caractères)') !!}
                                    {!! Form::text('compte', "", ['class' => 'form-control','placeholder'=>'Numéro de compte CPSWF']) !!}
                            </div>
                            <div class="col-md-4">
                                    {!! Form::label('designation', 'Designation') !!}
                                    {!! Form::text('designation', "DFIP", ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-5"></div>
                            <div class="col-md-2">
                                {!! Form::label('date_export', 'Date :') !!}
                                <div class='input-group date' id='datepicker_dateexport'>
                                        {!! Form::text('date_export', date('d/m/Y'), ['class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_dateexport').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>


                        @if($nbCompteIncorrect==0)
                            {!! Form::submit('Générer le fichier des paiement du mandat DFiP'
                                , ['class' => 'btn btn-success form-horizontal','style'=>'padding:10px;font-size:16px']) !!}
                        @else
                            {!! Form::button('Génération impossible<br/>certains comptes bancaires ne sont pas valides (21car. minimum)'
                                , ['class' => 'btn btn-danger form-horizontal','style'=>'font-size:16px']) !!}
                        @endif
                    @else 
                        {!! Form::hidden('path_nom_file',$path_nom_file); !!}
                        {!! Form::hidden('nom_file',$nom_file); !!}
                        <div class="col-xs-12 " align="center">
                            <div class="col-md-4"></div>

                            <div class="col-md-4">
                                <!--
                                {!! Form::label('fichier', 'Fichier : ') !!}
                                 {!! Form::text('nom_file',$nom_file,['class'=>'form-control'
                                    ]); !!}
                                -->
                            </div>
                            <div class="col-md-4"></div>
                        </div>

                        <div class="col-xs-12 row" style="padding-top:30px">
                            <div class="col-md-4"></div>
                            <div class="col-md-4">
                                <a href="{!! url($path_nom_file) !!}">
                                    <img src="{!! url('img/telecharge_fichier.png') !!}" 
                                        class="img-rounded" alt="Télécharger"
                                        target="_blank" width='20%' maxwidth='30%' />
                                </a>

                                <!-- 
                                <a href="javascript:" 
                                    onclick='$("form").submit();'>
                                    <img src="{!! url('img/email_envoi.png') !!}" 
                                        class="img-rounded"  alt="Envoyer par email"
                                        width='20%' maxwidth='30%' />
                                </a>
                            -->                        
                            </div>
                            <div class="col-md-4"></div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

    </div>
    {!! Form::close() !!}
</div>


@stop




