@include('forms.fbncheader')
@include('forms.fdatatables')


<div style="background-color:rgba(255,165,0,.2);"  
    class="col-lg-max col-lg-offset-1 container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/mandat.png", 
                    "Mandatements", array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                !!} 
            </div>
            <div class="col-xs-10" style="padding-left:0px;">
                <h1 style="margin-top:2px;">
                    Mandats
                </h1>
            </div>
        </div>

        <div class="row col-xs-2">
            {!! Form::label('annes', 'Années :' ) !!}
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('/mandatements/mandats_annee/') !!}/"
                            +$('#exercice_id').val();
                    });
                });
            </script>
        </div>
    </div>
    <br/>
    <div class='col-lg-max' style="padding-top:5px">
        <div class="">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1%' nowrap>N°</th>
                        <th width='1%'>Exe.</th>
                        <th width='1%'>Date</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Statut<br/>Transfert</th>
                        <th width='1%'>Date de validation</th>
                        <th>Créanciers</th>
                        <th>Imputations</th>
                        <th width='1%'>Total</th>
                        <th width='155px'></th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($mandats as $mandat)
                    <?php
                        $imputation=App\Models\Imputation::find($mandat->id);
                        $class_type="";
                        if($mandat->type=='A') $class_type='bg-danger';
                    ?>
                    <tr>
                        <td align="center">
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('mandatements/mandats/'.$mandat->id)!!}" 
                                    class="" style="margin-right: 3px;">
                            @endif

                            {!! str_pad($mandat->id,6,'0',STR_PAD_LEFT) !!}

                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif 
                        </td>
                        <td>{!! $mandat->exercice !!}</td>
                        <td>{!! $mandat->date_sai !!}</td>
                        <td>{!! $mandat->statut_mdt !!}</td>
                        <td>
                            {!! $mandat->StatutTransfertLibelle !!}
                            @if($mandat->statut_transfert=="TRA")
                                <br/>{!! $mandat->DateTransfert !!}
                            @endif
                        </td>
                        <td>{!! $mandat->date_valid !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeCreancierHTML() !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeImputationsHTML() !!}</td>
                        <td class='{!! $class_type !!}' nowrap align="right" style="color:darkblue;">{!! $mandat->montant !!}</td>
                        <td>
                        @if($user->can("MDT_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('mandatements/mandats/'.$mandat->id.'/edit') !!}" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;margin-bottom: 3px;">Modifier
                                </a>
                        @endif 
                        @if($user->can("MDT_TRF") || $user->HasRole("ADMINISTRATEUR"))
                                @if($mandat->statut_transfert=="")
                                <a href="{!! url('mandatements_settransfert/'.$mandat->id.'/'.$exercice) !!}" class="btn btn-sm btn-primary pull-left" style="margin-right: 3px;margin-bottom: 3px;">A Transférer
                                </a>
                                @endif 
                                @if($mandat->statut_transfert=="ATR")
                                <a href="{!! url('mandatements_unsettransfert/'.$mandat->id.'/'.$exercice) !!}" class="btn btn-sm btn-warning pull-left" style="margin-right: 3px;margin-bottom: 3px;">Ne pas Transférer
                                </a>
                                @endif 
                        @endif 
                        @if(($user->can("MDT_SUP")|| $user->HasRole("ADMINISTRATEUR"))   
                            && ($mandat->statut_mdt=="ANN"))  
                            <span style=""> 
                            {!! Form::open(['url' => '/mandatements/mandats/' . $mandat->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-sm btn-danger'])!!}
                            {!! Form::close() !!}
                            </span> 
                        @endif 
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @if($user->can("MDT_AJO") || $user->HasRole("ADMINISTRATEUR"))
         <div>
            <h4><a href="{!! url('mandatements/mandats/create') !!}" class="btn btn-success">Ajouter un Mandat</a></h4>
        </div> 
    @endif
    </div>
</div>

</body></html>


@include('forms.fdatatables_script')