@extends('layouts.master')
 
@section('title') Consultation d'un Mandat @stop
 
@section('content')
 

 @section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
@stop

<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Mandat <small>Consultation</small></h1>
 
    {!! Form::model($mandat, ['mandat' => 'form'
        , 'url' => '', 'method' => 'GET', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">
        <div class="form-group">
            <div class="col-md-2">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='{!! str_pad($mandat->id, 6, "0", STR_PAD_LEFT) !!}' />
                    </div>
               </div>
           </div>
        </div>

        <div class="form-group">
            <div class="col-md-1">
                {!! Form::label('exercice', 'Exercice') !!}
                {!! Form::text('exercice', null, ['class' => 'form-control','readonly']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('date_sai', 'Date') !!}
                {!! Form::text('date_sai', null, ['class' => 'form-control','readonly']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('statut_mdt', 'Statut') !!}
                {!! Form::text('statut_mdt',null, ['class' => 'form-control','readonly']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('type', 'Type') !!}
                {!! Form::text('type',(($mandat->type=='A')?'Annulation':'Paiement'), ['class' => 'form-control','readonly']) !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('observation', 'Observations') !!}
            {!! Form::textarea('observation', null, ['class' => 'form-control', 'rows'=>'2','readonly']) !!}
            </div>
        </div>


        <div class="col-md-8 bg-success" >  
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Directeur</i></b></legend>
                    {!! Form::label('date_valid_dir', 'Date') !!}
                    {!! Form::text('date_valid_dir', $mandat->date_valid_dir, ['class' => 'form-control','readonly']) !!}
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_val', 'Observations') !!}
                    {!! Form::textarea('observation_val', null, ['class' => 'form-control', 'rows'=>'2','readonly']) !!}
                </div>

            </div>
        </div>


        <div class="col-md-8 bg-info" >
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Comptable</b></i></legend>
                    {!! Form::label('date_valid', 'Date') !!}
                    {!! Form::text('date_valid', null, ['class' => 'form-control','readonly']) !!}
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_dir', 'Observations') !!}
                    {!! Form::textarea('observation_dir', null, ['class' => 'form-control', 'rows'=>'2','readonly']) !!}
                </div>

            </div>
        </div>


        <!-- IMPUTATIONS -->
        <div class="bg-warning">
            <div class="col-xs-8 " >
                <h4>Imputations</h4>
                {!! Form::hidden('select_input', null, ['id' => 'select_input']) !!}
                    <table id="_table" class="table table-condensed table-hover table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='1%'>Compte</th>
                                <th >Désignation</th>
                                <th width='1%'>Montant</th>
                                <th width='1%'>Type</th>
                                <th >Observations</th>
                                <th  width='1%'></th>
                            </tr>
                        </thead>
             
                        @if(isset($imputations)) 
                        <tbody>
                            @foreach($imputations as $imputation)
                            <tr class="clickable-row" data-href="{!! $imputation->id !!}">
                                <td id='numimput_{!! $imputation->id !!}' class="">{!! $imputation->id !!}</td>
                                <td align='center'>{!! $imputation->cpt_imp !!}</td>
                                <td >{!! $imputation->designation !!}</td>
                                <td align='center'>{!! $imputation->montant !!}</td>
                                <td align='center'>{!! $imputation->type_imp !!}</td>
                                <td >{!! $imputation->obs !!}</td>
                                <td >
                                    <a href="{!! url('imputations_show_frame/'.$imputation->id) !!}" 
                                        class="box_imput fancybox.iframe btn btn-warning" 
                                        id='btn_visu_imputation' 
                                        style="margin-right: 3px;">Consulter</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        @endif
                    </table>

                <script>
                jQuery(document).ready(function($) {
                    $(".clickable-row").click(function() {
                        var id=$(this).data("href");
                        var old_select=$('#select_input').val();
                        $('#numimput_'+old_select).removeClass('bg-danger');
                        if(old_select==id) {
                            $('#select_input').val("");
                            $('.btn_imput').attr('disabled','disabled');   
                            return;
                        }
                        $('#numimput_'+id).addClass('bg-danger');
                        $('#select_input').val(id);
                        $('.btn_imput').removeAttr('disabled');
                    });
                });

                function imprime_imputation(nom) {
                    var url="";
                    //if(nom=="mandat_mandat_pmt_imp") {
                    //    url="{!! url('mandat_mandat_pmt_imp')."/".$mandat->id !!}";
                    //} else {
                        //if($('#select_input').val()=="") {
                        //    alert('Il faut sélectionner une imputation');
                        //    return;
                        //}
                        if(nom=="mandat_mandat_pmt_imp") {
                            url="{!! url('mandat_mandat_pmt_imp'.'/'.$mandat->id) !!}";
                            if($('#select_input').val()!="") url+="/"+$('#select_input').val();
                        }
                        if(nom=="mandat_imputation") {
                            if($('#select_input').val()=="") {
                                alert("Vous devez selectionner une imputation");
                                return;
                            }
                            url="{!! url('mandat_imputation'.'/'.$mandat->id) !!}";
                            if($('#select_input').val()!="") url+="/"+$('#select_input').val();
                        }
                        if(nom=="mandat_ordre_pmt_imp") {
                            url="{!! url('mandat_ordre_pmt_imp'.'/'.$mandat->id) !!}";
                            if($('#select_input').val()!="") url+="/"+$('#select_input').val();
                            if($('#select_creancier').val()!="") {
                                url+="/"+$('#select_creancier').val();
                            } else {
                                $('#dialog-creancier').dialog( 'open' );return ;
                            }
                            
                        }
                    //}
                    window.open(url,'_blank');
                }

                </script>

                </div>
            </div>

            <div>


            </div>

            <div class="col-lg-12">
                <div class="form-group">

                    <a href="javascript:" onclick="imprime_imputation('mandat_imputation');return false;" 
                    class="  btn btn-info" 
                    target="_blank">Imputation</a>

                    <a href="javascript:" onclick="imprime_imputation('mandat_ordre_pmt_imp');return false;" 
                    class="  btn btn-info" 
                    target="_blank" >Ordre de paiement</a>

                    <a href="javascript:" onclick="imprime_imputation('mandat_mandat_pmt_imp');return false;" 
                    class=" btn btn-info" 
                    target="_blank">Mandat de paiement</a>
                </div>


                <div id="dialog-creancier" title="Saisie du créancier">
                    <div class="col-xs-10">
                        {!! Form::label('nom_benef', 'Nom du bénéficiaire :') !!}
                        {!! Form::text('nom_benef', '', ['placeholder' => "Nom du bénéficiaire",
                            'id'=>'nom_benef', 'class' => 'form-control']) !!}
                        {!! Form::text('lieu_benef', '', ['placeholder' => "Lieu",
                            'id'=>'lieu_benef', 'class' => 'form-control']) !!}
                    </div>
                </div>
                  <script>
                  $( function() {
                    
                    $( "#dialog-creancier" ).dialog({
                      resizable: false,
                      height: "auto",
                      width: 400,
                      modal: true,
                      autoOpen: false,
                      buttons: {
                        "Imprimer": function() {
                          $( this ).dialog( "close" );
                          //$('#nom_benef').val()=$('#nom_benef').val().replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
                          url="{!! url('mandat_ordre_pmt_imp_nom'.'/'.$mandat->id) !!}";
                          url+="/"+$('#nom_benef').val();
                          url+="@@"+$('#lieu_benef').val();
                          window.open(url,'_blank');

                        },
                        Annuler: function() {
                          $( this ).dialog( "close" );
                        }
                      }
                    });
                  } );
                  </script>

            </div>

        </div>


        <!-- CREANCIERS -->
        <div class="row " >
            <div class="col-xs-8 " >
                <h4>Créanciers</h4>
                {!! Form::hidden('select_creancier', null, ['id' => 'select_creancier']) !!}
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th nowrap width='1%'>N°Imput.</th>
                                <th nowrap width='1%'>N°Bénéf.</th>
                                <th >Nom</th>
                                <th width='20%'>Banque</th>
                                <th width='1%'>Compte</th>
                                <th width='1%' >Montant</th>
                                <th  width='1%'></th>
                            </tr>
                        </thead>
             
                        @if(isset($creanciers)) 
                        <tbody>
                            @foreach($creanciers as $creancier)
                            <tr class="clickable-row-creancier" data-href="{!! $creancier->id !!}">
                                <td align='center' style='font-style:italic;color:lightgrey' 
                                        id='numimput_{!! $creancier->id !!}' >{!! $creancier->id !!}</td>
                                <td align='center'>{!! $creancier->idimp_mdt !!}</td>
                                <td align='center'>{!! $creancier->num_creancier !!}</td>
                                
                                <td nowrap>{!! $creancier->nom_complet !!}</td>
                                <td align='center'>{!! ($creancier->bqcle_creancier==0)?"":$creancier->bqcle_creancier."-".$creancier->banque !!}</td>
                                <td align='center'>{!! $creancier->compte !!}</td>
                                <td align='right'>{!! $creancier->montant !!}</td>
                                <td nowrap>
                                    <a href="{!! url('creancier_show_frame/'.$creancier->id) !!}" 
                                        class="box_creancier fancybox.iframe btn btn-warning" 
                                        id='btn_visu_imputation' 
                                        style="margin-right: 3px;">Consulter</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        @endif
                    </table>


                <script>
                jQuery(document).ready(function($) {
                    $(".clickable-row-creancier").click(function() {
                        var id=$(this).data("href");
                        var old_select=$('#select_creancier').val();
                        $('#numimput_'+old_select).removeClass('bg-danger');
                        if(old_select==id) {
                            $('#select_creancier').val("");
                            $('.btn_creancier').attr('disabled','disabled');   
                            return;
                        }
                        $('#numimput_'+id).addClass('bg-danger');
                        $('#select_creancier').val(id);
                        $('.btn_creancier').removeAttr('disabled');
                    });
                });

                function imprime_creancier(nom) {
                    if($('#select_creancier').val()=="")  {
                        alert('Il faut sélectionner un créancier');
                        return;
                    }
                    var url="";
                    if(nom=="mandat_bordereau_rglmt") url="{!! url('mandat_bordereau_rglmt') !!}"+"/"+$('#select_creancier').val();;
                    if(nom=="mandat_mandat_pmt_cre") {
                        url="{!! url('mandat_mandat_pmt_imp').'/'.$mandat->id !!}";
                        if($('#select_input').val()=="") url+="/0"+"/"+$('#select_creancier').val();
                        else url+="/"+$('#select_input').val()+"/"+$('#select_creancier').val();
                    }
                    window.open(url,'_blank');
                }

                function imprime_annulation() {

                    var url="";
                    var imput=$('#select_input').val();
                    if(imput=="") imput="0";
                    var creancier=$('#select_creancier').val();
                    if(creancier=="") creancier=0;
                    url="{!! url('mandat_mandat_annulation').'/'.$mandat->id !!}";
                    url+="/"+imput+"/"+creancier;

                    window.open(url,'_blank');
                }

                </script>


                </div>
            </div>
            <div class="col-lg-12">
                <div class="form-group">
               <a href="javascript:" onclick="imprime_creancier('mandat_bordereau_rglmt');return false;"
                class="btn_creancier  btn btn-info" 
                disabled target="_blank">Bordereau de règlement</a>

                <a href="javascript:" onclick="imprime_creancier('mandat_mandat_pmt_cre');return false;"
                class="btn_creancier  btn btn-info" 
                disabled target="_blank">Mandat de paiement</a>

                <a href="javascript:" onclick="imprime_annulation();return false;"
                class="btn_imput btn_creancier  btn btn-info" 
                disabled target="_blank">Mandat d'annulation</a>
                </div>
            </div>



        </div>

    </div>


    {!! Form::close() !!}
    
    <div class="col-sm-9">
        <div class='form-group'><br/>
            <a class="btn btn-warning" href="{!! url('mandatements/mandats') !!}">
                Retour</a>
        </div>
    </div>

</div>
 

@stop


@section('scripts')
    {!! Html::script('js/jquery.fancybox.js') !!}


<script type="text/javascript">

    $(document).ready(function() {
        
         $('#_table tbody').on( 'click', 'tr', function () {
            $(this).toggleClass('selected');
        } );

        $(".box_imput").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });



        $(".box_creancier").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });

    });

    </script>
@stop