@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-secteurs"></i>Statuts des bénéficiaires</h1>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>Id</th>
                    <th>Référence</th>
                    <th>Libellé</th>
                    <th width='1%' style='text-align:center'>Nb bénéficiaire</th>
                    <th width='1%'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($benef_statuts as $benef_statut)
                <tr>
                    <td>{!! $benef_statut->id !!}</td>
                    <td nowrap>{!! $benef_statut->ref !!}</td>
                    <td nowrap>{!! $benef_statut->libelle !!}</td>
                    <td style='text-align:center'>{!! $benef_statut->nombre_beneficiaire !!}</td>
                    <td nowrap>
                    @if($user->can("BES_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="./benef_statuts/{!! $benef_statut->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                    @endif 
                    @if( ($user->can("BES_MAJ") || $user->HasRole("ADMINISTRATEUR")) 
                        && ($benef_statut->nombre_beneficiaire==0) )  
                            {!! Form::open(['url' => '/param/benef_statuts/' . $benef_statut->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                          {!! Form::close() !!}
                    @endif 
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
@if($user->can("BES_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="./benef_statuts/create" class="btn btn-success">Ajouter un Statut</a></h4>
    </div> 
@endif

</div>

</body></html>
<script>
$(document).ready(function() {
    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: false,
        bFilter: true,
        deferRender:    true,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
            dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                {extend: 'print',exportOptions: {columns: ':visible'} },
                'colvis'
            ],



        } );

} );
</script>