@include('forms.fbncheader')
@include('forms.fdatatables')

{!! Html::style('css/bootstrap-select.min.css') !!}
{!! Html::style('css/datepicker3.css') !!}


{!! Html::script('js/bootstrap-datepicker.js') !!} 
{!! Html::script('js/bootstrap-select.js') !!}



{!! $maj=( ($user->can("PAR_MAJ")) || $user->HasRole("ADMINISTRATEUR"))?true:false !!}

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-epreuves"></i>Saisie des Paramètres</h1>
</div>



<div class="col-lg-12 col-lg-offset-1">
{!! Form::model($parametres, ['parametre' => 'form', 'class' => 'form-horizontal'
    , 'url' => 'param/parametres/0', 'method' => 'PUT']) !!}

    <ul class="nav nav-tabs">
        <li class="active"><a href="#messages" data-toggle="tab">Messages</a></li>
        <li><a href="#paramcalcul" data-toggle="tab">Taux CLR/CCPF</a></li>
        <li><a href="#editions" data-toggle="tab">Editions</a></li> 
        <li><a href="#recouvrement" data-toggle="tab">Recouvrement</a></li>
        <li><a href="#compta" data-toggle="tab">Comptabilité</a></li>
        <li><a href="#email" data-toggle="tab">Emails</a></li> 
        <li><a href="#divers" data-toggle="tab">Divers</a></li> 
    </ul>
    <script>
        $('#myTab a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
        })

        $('a[data-toggle="tab"]').on('shown', function (e) {
        e.target // activated tab
        e.relatedTarget // previous tab
        })
    </script>


<div class="tab-content">


<!-- ------------------------------------- ONGLET Messages ------------------------------- -->
    <div class="tab-pane active" id="messages">
        <div class="form-group">
            <div class="col-lg-10">
            @foreach ($parametres as $parametre)
                @if(substr($parametre->ref2,0,3)=='MSG')

                    {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    @if($maj)
                        {!! Form::textarea($parametre->ref2, $parametre->value, 
                            ['placeholder' => 'Texte', 'class' => 'form-control'
                            ,'rows' => '7'
                            ]) !!}
                    @else
                        {!! Form::textarea($parametre->ref2, $parametre->value, 
                            ['readonly', 'class' => 'form-control','rows' => '7']) !!}
                    @endif

                @endif
            @endforeach
            </div>
        </div>
    </div>
<!-- FIN Onglet 1 -->

<!-- ------------------------------------- ONGLET Calculs et taxes ------------------------------- -->
    <div class="tab-pane" id="paramcalcul">
            @foreach ($parametres as $parametre)

               @if( (substr($parametre->ref2,0,3)=='CAL') )
                <div class="form-group">
                    <div class="col-md-4">
                    {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    @if($maj)
                        {!! Form::text($parametre->ref2, $parametre->value, 
                        ['placeholder' => 'Texte', 'class' => 'form-control'
                        
                        ]) !!}
                    @else
                        {!! Form::text($parametre->ref2, $parametre->value, 
                        ['readonly', 'class' => 'form-control']) !!}
                    @endif
                    </div>
                </div>
                @endif

                @if( (substr($parametre->ref2,0,4)=='TAUX') )
                    <div class="form-group">
                        <div class="table-responsive col-md-6">
                            {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                            <table id="_table" class="table table-condensed table-striped table-bordered" width="100px">
                                <thead>
                                    <tr>
                                        <th width='30px'>Exercice</th>
                                        <th width='40px'>%CLR</th>
                                        <th width='40px'>%CCPF</th>
                                        <th width='40px'>%Total</th> 
                                    </tr>
                                </thead>
                     
                                <tbody>
                                    <?php 
                                    if($parametre->value) $t_taux=explode("\r\n",$parametre->value); 
                                    rsort($t_taux);
                                    $max_annee=(intval(substr($t_taux[0],0,4))+1);
                                    $t_taux[]=$max_annee.";;";
                                    rsort($t_taux);
                                    
                                    foreach($t_taux as $taux) {
                                        $taux_values=explode(";",$taux);
                                        $annee=$taux_values[0];
                                        $taux_clr=$taux_values[1];
                                        $taux_ccpf=$taux_values[2];
                                        if($taux_clr=="") $taux_clr=0; 
                                        if($taux_ccpf=="") $taux_ccpf=0;
                                    ?>

                                        <tr>
                                            <td style="color:grey">{!! $annee !!}</td>
                                            <td align="center">
                                                @if($maj)
                                                {!! Form::text($parametre->ref2."_clr_".$annee, 
                                                    $taux_clr, ['placeholder' => '%CLR', 'class' => 'form-control']) !!}
                                                @else
                                                {!! Form::text($parametre->ref2."_clr_".$annee, 
                                                    $taux_clr, ['readonly', 'class' => 'form-control']) !!}
                                                @endif
                                            </td>
                                            <td align="center">
                                                @if($maj)
                                                {!! Form::text($parametre->ref2."_ccpf_".$annee, 
                                                    $taux_ccpf, ['placeholder' => '%CCPF', 'class' => 'form-control']) !!}
                                                @else
                                                {!! Form::text($parametre->ref2."_ccpf_".$annee, 
                                                    $taux_ccpf, ['readonly', 'class' => 'form-control']) !!}
                                                @endif
                                            </td>
                                            <td align="center">{!! $taux_clr+$taux_ccpf !!} %</td>
                                        </tr>
                                    <?php } ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                @endif
                
               @if( (substr($parametre->ref2,0,3)=='LST') )
                <div class="form-group">
                    <div class="col-md-4">
                    {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    @if($maj)
                        {!! Form::textarea($parametre->ref2, $parametre->value, ['placeholder' => 'Texte', 'class' => 'form-control','rows'=>'10']) !!}
                    @else
                        {!! Form::textarea($parametre->ref2, $parametre->value, ['readonly', 'class' => 'form-control','rows'=>'10']) !!}
                    @endif
                    </div>
                </div>
                @endif
            @endforeach
    </div>
<!-- FIN Onglet 2 -->


<!-- ------------------------------------- ONGLET Editions ------------------------------- -->
<div class="tab-pane" id="editions">
        @foreach ($parametres as $parametre)
            @if(substr($parametre->ref2,0,3)=='EDI')
                <div class="form-group">
                    <a href="#txt_{!! $parametre->ref2 !!}" data-toggle="collapse">
                    {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    </a>
                    <div id="txt_{!! $parametre->ref2 !!}" class="form-control  collapse">
                        @if($parametre->type=='T')
                        
                            @if($maj)
                            {!! Form::textarea($parametre->ref2, $parametre->value, 
                                ['placeholder' => 'Texte', 
                                    'class' => 'form-control',
                                    'rows' => '4']) !!}
                            @else
                            {!! Form::textarea($parametre->ref2, $parametre->value, 
                                ['readonly', 
                                    'class' => 'form-control',
                                    'rows' => '4']) !!}
                            @endif
                        
                        @else
                            {!! Form::text($parametre->ref2, $parametre->value, 
                                ['placeholder' => 'Valeur', 'class' => 'form-control']) !!}
                        @endif
                    </div>
                </div>
            @endif
        @endforeach
</div>

<!-- FIN Onglet 3 -->


<!-- ------------------------------------- ONGLET Recouvrement ------------------------------- -->
    <div class="tab-pane" id="recouvrement">
            <br/>
            <div class="form-group">
            @foreach ($parametres as $parametre)
                @if(substr($parametre->ref2,0,3)=='REC')
                <div class="form-group">
                    <div class="col-md-3">
                        {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-2">
                        {!! Form::text($parametre->ref2, $parametre->value, 
                        ['placeholder' => 'Texte', 'class' => 'form-control']) !!}
                    </div>
                </div> 
                @endif
            @endforeach    
            </div>       

    </div>


<!-- ------------------------------------- ONGLET Compta ------------------------------- -->
    <div class="tab-pane" id="compta">  
        <div class='row form-group'>  
            <div class="col-xs-2">    
                @foreach ($parametres as $parametre)
                    @if(substr($parametre->ref2,0,3)=='CPT')
                        {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                        {!! Form::text($parametre->ref2, $parametre->value, 
                        ['placeholder' => 'Texte', 'class' => 'form-control']) !!}
                    
                    @endif
                @endforeach
            </div>
        </div>
    </div>

<!-- ------------------------------------- Emails ------------------------------- -->
    <div class="tab-pane" id="email">
        <div class="form-group">
            <div class="col-lg-10"> 
            @foreach ($parametres as $parametre)
                @if(substr($parametre->ref2,0,3)=='MAI')
                    {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                    @if($parametre->type=='T')
                        {!! Form::textarea($parametre->ref2, $parametre->value, 
                            ['placeholder' => 'Texte', 
                                'class' => 'form-control',
                                'rows' => '4']) !!}
                    @else
                        {!! Form::text($parametre->ref2, $parametre->value, 
                            ['placeholder' => 'Valeur', 'class' => 'form-control']) !!}
                    @endif
                @endif
            @endforeach
            </div>
        </div>
    </div>

<!-- ------------------------------------- ONGLET Divers ------------------------------- -->
    <div class="tab-pane" id="divers">
        <div class="form-group">
            <div class="col-lg-10"> 
            @foreach ($parametres as $parametre)
                @if(substr($parametre->ref2,0,3)=='DIV')

                {!! Form::label($parametre->ref2, $parametre->info,['style'=>'padding-top:20px']) !!}
                {!! Form::text($parametre->ref2, $parametre->value, 
                    ['placeholder' => 'Texte', 'class' => 'form-control']) !!}

                @endif
            @endforeach
            </div>
        </div>
    </div>


<!-- FIN Onglet 1 -->

</div>

@if( ($user->can("PAR_MAJ")) || $user->HasRole("ADMINISTRATEUR")) 
<div class="col-lg-max"> 
    <div class="row"> 
        <div class='form-group'>
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
</div>
@endif


{!! Form::close() !!}
</div>



</body></html>
<!-- @include('forms.fdatatables_script_2') -->

<script>
$(document).ready(function() {
    $('#_table').dataTable( {
    	"width": "10%",
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": false,
        "bFilter": false,
        } );
    } );



} );


$(function() {
$( "#accordion" ).accordion();
});

</script>