@include('forms.fbncheader')
@include('forms.fdatatables')


<div class="col-lg-max col-lg-offset-1">
    <h1>Réajustement des retraites</h1>


    @if($mode=='saisie')
       {!! Form::open(['generation' => 'form', 
            'url' => 'retraites/reajustement_simulation/', 'method' => 'POST', 'class' => 'form-horizontal']) !!}
        <div class="alert col-xs-10 row bg-danger">
                <div class="col-xs-10 " style="">
                    <h4>
                        <div class="col-xs-10">
                            Cette opération va permettre de réajuster toutes les retraites en cours.
                        </div>
                     </h4>
                     <br/>
                     <h4 class="col-xs-10">
                         <div class="col-xs-5">Taux de réajustement (%) :</div>
                         <div class="col-xs-2" stye="margin-top:0px"> 
                        {!! Form::text('taux', '', ['class' => 'form-control',
                            'style'=>'font-weight:bold;font-size:23px;text-align:center']) !!}
                        </div>
                    </h4>
                     <h4 class="col-xs-10">
                         <div class="col-xs-5">Nombre de rappels :</div>
                         <div class="col-xs-2" stye="margin-top:0px"> 
                        {!! Form::text('nb_rap', '', ['class' => 'form-control',
                            'style'=>'font-weight:bold;font-size:23px;text-align:center']) !!}
                        </div>
                    </h4>
                    <br/>
                    <h4 class="col-xs-10">
                        Cliquez sur le bouton ci-dessous pour générer ce fichier.
                    </h4>
                </div>
        </div>

        <div class="col-xs-10">
            <div class="form-group" align="center">
                    {!! Form::submit('Visualisation de la simulation'
                        , ['class' => 'btn btn-success form-horizontal','style'=>'font-size:24px']) !!}
            </div>
        </div> 
        {!! Form::close() !!}
    @endif    

    @if($mode=='confirm')
        {!! Form::open(['url' => 'retraites/reajustement_validation/', 'method' => 'POST']) !!}
        {!! form::hidden('taux',$taux,['id'=>'taux']) !!}
        {!! form::hidden('nb_rap',$nb_rap,['id'=>'nb_rap']) !!}

        <div class='col-lg-10' style="padding-top:5px">
            <div class="">
                <table id="_table" style="background-color:white" 
                    class="table table-striped table-bordered table-hover" width="100%" 
                    >
                    <thead>
                        <tr>
                            <th width='1%'>Id</th>
                            <th>Nom</th>
                            <th width='5%'>Date de naissance</th>
                            <th width='10%'>Montant Ret.</th> 
                            <th width='10%'>Montant Réajusté (+{!! $taux !!}%)</th> 
                            <th width='10%'>Montant Rap.</th> 
                            <th width='10%'>Montant Rap.Réajusté<br/>(+{!! $taux !!}%&nbsp;sur&nbsp;{!! $nb_rap !!}&nbsp;mois)</th> 
                            <th width='1%'>Statut</th>
                            <th width='1%'>TypeRet</th>
                            <th width='1%'>DateReajust.</th>
                        </tr>
                    </thead>
         
                    <tbody>
                        @foreach ($beneficiaires as $beneficiaire)
                        <?php
                            $areajuster=true;//($beneficiaire->ret_date_reajust=='0000-00-00 00:00:00');
                            //Modif pour réajust dans l'année 07/2020
                            if(substr($beneficiaire->ret_date_reajust,0,4)=="2020") $areajuster=false;
                            $new_montant=$beneficiaire->ret_montant;
                            $new_rappel=$beneficiaire->ret_rappel;
                            if($areajuster) {
                                $new_montant=round($beneficiaire->ret_montant*(1+($taux/100)),0);
                                $new_rappel=$beneficiaire->ret_rappel+$nb_rap*(round($beneficiaire->ret_montant*($taux/100),0));
                            }
                            $new_montant=number_format($new_montant,0,","," ");
                            $new_rappel=number_format($new_rappel,0,","," ");
                        ?>
                        <tr>
                            <td>{!! str_pad($beneficiaire->id, 6, "0", STR_PAD_LEFT) !!}</td>
                            <td>{!! $beneficiaire->nom_complet !!}</td>
                            <td>{!! $beneficiaire->datenaiss !!}</td> 
                            <td align="center">{!! $beneficiaire->ret_montant !!}</td>
                            <td align="center" class='{!! ($areajuster)?"btn-danger":"" !!}'>{!!  $new_montant !!}</td>  
                            <td align="center">{!! $beneficiaire->ret_rappel !!}</td>
                            <td align="center" class='{!! ($areajuster)?"btn-danger":"" !!}'>{!! $new_rappel !!}</td>  
                            <td align="center">{!! $beneficiaire->statut !!}</td>
                            <td align="center">{!! $beneficiaire->ret_type !!}</td>
                            <td align="center">{!! $beneficiaire->ret_date_reajust !!}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="col-md-3" >     
                    {!! Form::submit('Valider la mise à jour des retraites', ['class' => 'btn btn-primary']) !!} 
            </div> 
        </div>

        {!! Form::close() !!}
    @endif 



    @if($mode=='validation')
        <div class="alert col-xs-10 row bg-success">
                <div class="col-xs-10 " style="">
                    <h4 class='alert'>
                        <div class="col-xs-10">
                            La mise à jour des retraites de {!! $nb !!} bénéficaires a été effectuée.
                        </div>
                     </h4>
                </div>
        </div>
    @endif  
</div>


</body></html>

<script>
$(document).ready(function() {
   $.fn.dataTable.moment('D/M/YYYY');

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: true,
        bInfo: true,
        bFilter: true,
        deferRender:    true,
        //scrollY:        400,
        scrollCollapse: false,
        scroller:       false,

        iDisplayLength:25,
        oLanguage: {
            "sLengthMenu": 'Lignes par page <select>'+
            '<option value="25">25</option>'+
            '<option value="50">50</option>'+
            '<option value="100">100</option>'+
            '<option value="-1">Tous</option>'+
            '</select> ',
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",

            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
            dom: "<'row'<'col-sm-4 text-left'fl><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                {extend: 'pdf',exportOptions: {columns: ':visible'} },
                {extend: 'print',exportOptions: {columns: ':visible'} },
                'colvis'
            ],
            
        } );


} );
</script>
