@extends('layouts.master')
 
@section('title') Exportation des versements TP @stop
 
@section('content')
 

<div class="col-lg-10 col-lg-offset-1">

    @if(!isset($nom_file))
        <h1>{!! "Génération du fichier TP pour les ".$user->getTitreStatut($type) !!}</h1>   
           {!! Form::open(['form' => 'generation', 
                'url' => 'versements_export_fichier_TP/'.$type.'/'.$num_imp, 'method' => 'POST'
                , 'class' => 'form-horizontal']) !!}
    @else

        <h1>{!! "Transmission fichier TP pour les ".$user->getTitreStatut($type) !!}</h1>   
           {!! Form::open(['form' => 'form', 
                'url' => 'versements_email_fichier', 'method' => 'POST'
                , 'class' => 'form-horizontal']) !!}

    @endif


    <div class="alert col-xs-12 row bg-{!! (!isset($nom_file)?'danger':'success')!!}">
            <div class="col-xs-2">
                @if(!isset($nom_file))
                   {!! Html::image("img/process.png", "Export", 
                    array( 'maxwidth' => '30%','width' => '60%' )) !!} 
                @else
                   {!! Html::image("img/process_valide.png", "Export", 
                    array( 'maxwidth' => '30%','width' => '60%' )) !!} 
                @endif
            </div>
            <div class="col-xs-10 " style="">
                <h4>
                    @if(!isset($nom_file))
                        Cette opération va permettre de générer un fichier destiné à la DFiP.
                        <br/>Ce fichier ne contiendra les opérations de versement de l'imprimé N° {!! $num_imp !!} pour les bénéficiaires <b>{!! $user->getTitreStatut($type,true) !!} </b>.
                        <br/><br/>Cliquez sur le bouton ci-dessous pour générer ce fichier.


                    @else
                        Le fichier a été généré. Il contient <b>{!! $nb_lignes !!} lignes</b>.
                        <br/>Vous pouvez le télécharger en faisant un <i>clique-droit</i> puis <i>enregistrer le lien sous</i> sur l'icône ci-dessous..
                    @endif
                </h4>
            </div>
    </div>




    <div class="col-xs-12">
        <div class="form-group" align="center">
                @if(!isset($nom_file))
                <div class="form-group">
                    <div class="col-md-3">
                            {!! Form::label('compte', 'Compte (11 caractères)') !!}
                            {!! Form::text('compte', "", ['class' => 'form-control','placeholder'=>'Numéro de compte CPSWF']) !!}
                    </div>
                    <div class="col-md-3">
                            {!! Form::label('designation', 'Designation') !!}
                            {!! Form::text('designation', "DFIP", ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="form-group">
                  <div class="col-md-2">
                        {!! Form::label('date_export', 'Date :') !!}
                        <div class='input-group date' id='datepicker_datenaiss'>
                                {!! Form::text('date_export', date('d/m/Y'), ['class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_datenaiss').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>


                {!! Form::submit('Générer le fichier des versements DFiP'
                    , ['class' => 'btn btn-danger form-horizontal','style'=>'font-size:24px']) !!}
            @else
            
             {!! Form::hidden('path_nom_file',$path_nom_file); !!}
              {!! Form::hidden('nom_file',$nom_file); !!}
                <div class="col-xs-12 " align="center">
                    <div class="col-md-4"></div>

                    <div class="col-md-4">
                        <!--
                        {!! Form::label('fichier', 'Fichier : ') !!}
                         {!! Form::text('nom_file',$nom_file,['class'=>'form-control'
                            ]); !!}
                        -->
                    </div>
                    <div class="col-md-4"></div>
                </div>

                <div class="col-xs-12 row" style="padding-top:30px">
                    <div class="col-md-4"></div>
                    <div class="col-md-4">
                        <a href="{!! url($path_nom_file) !!}">
                            <img src="{!! url('img/telecharge_fichier.png') !!}" 
                                class="img-rounded" alt="Télécharger"
                                target="_blank" width='20%' maxwidth='30%' />
                        </a>

                        <!-- 
                        <a href="javascript:" 
                            onclick='$("form").submit();'>
                            <img src="{!! url('img/email_envoi.png') !!}" 
                                class="img-rounded"  alt="Envoyer par email"
                                width='20%' maxwidth='30%' />
                        </a>
                    -->



                        
                    </div>
                    <div class="col-md-4"></div>
                </div>
            @endif
        </div>
    </div>


</div>


@stop




