@include('forms.fbncheader')
@include('forms.fdatatables')


<div class="col-lg-max col-lg-offset-1">
    <h1><i class="fa fa-employeurs"></i>{!! $titre_versement !!}
    @if(isset($annee_mois) && ($annee_mois<>""))
        <i class="fa fa-employeurs"></i>de : {!! $lib_mois_brouillard." ".substr($annee_mois,0,4) !!}
    @endif
    </h1>

    @if((count($versements_b)==0))
        <div class="col-sm-9">
            <div class='bg-danger alert'>Vous pouvez générer le brouillard du mois {!! $mois_brouillard !!} </div>
        </div>
    @endif


   {!! Form::open(['versements_b' => 'form', 
        'url' => 'versements_genedef/'.$type.'/'.$annee_mois, 'method' => 'GET', 'class' => 'form-horizontal']) !!}

    <div class="col-sm-9">
        <div class="form-group">       
             <div>
               <a id='bt_brouillard'  href="{!! url('versements_genebro/'.$type.'/'.$mois_brouillard) !!}" 
                    class="btn btn-success" style="margin-left:20px">
                    {!! ((count($versements_b)>0)?"Refaire une génération":"Génération du mois de ".$lib_mois_brouillard)." en mode brouillon" !!}</a>

                @if(date('Y-m')!=$mois_brouillard)
                     <span class="" style="color:red">Vous devez attendre le début du mois pour pouvoir générer les versements définitifs</span>
                @else
                    <a  id='bt_def' name='bt_def' 
                        href="{!! url('versements_genedef/'.$type.'/'.$mois_brouillard) !!}" 
                        class="btn btn-danger {!! (count($versements_b)>0)?'':'disabled' !!}"
                        onclick='$("bt_def").show()'>
                            Attention ! Cliquez-ici pour effectuer la Génération Définitive du mois de {!! $lib_mois_brouillard !!}
                        </a>
                    <a href="#"  id='bt_confirm' class="btn btn-warning" onclick='javasript:show_bt();'>Génération Définitive</a>
                    <a href="#"  id='bt_annuler' class="btn btn-warning" onclick='javasript:annuler_def();'>Annuler</a>
                    <script>
                        $("#bt_def").hide();
                        $("#bt_annuler").hide();
                        function show_bt() {
                            $("#bt_def").show();
                            $("#bt_confirm").hide();
                            $("#bt_brouillard").hide();
                            $("#bt_annuler").show();
                        }

                        function annuler_def() {
                            $("#bt_def").hide();
                            $("#bt_confirm").show();
                            $("#bt_brouillard").show();
                            $("#bt_annuler").hide();
                        }
                    </script> 
                @endif

            </div> 
        </div>
     </div>
</div>

<br/>
<div class="col-lg-max" >&nbsp;</div>
<hr/>

@if((count($versements_b)>0))
<div class="col-lg-max col-lg-offset-1">
    <div class="col-sm-11">
        <div class='form-group'>
            {!! Form::label('banque', 'Banque') !!}
            {!! Form::select(
                'banque_id',
                array("ALL"=>"Toutes les banques")+$liste_banques,
                $banque_id,
                [
                    'id' => 'banque_id',
                    'class' => 'form-control selectpicker',
                    'style' => 'font-weight:bold;',
                    'data-width' => '20%'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#banque_id').on('change', function() {
                        var banque_id=$('#banque_id').val();
                        location.href="{!! url('versements_generation/'.$type.'/'.$annee_mois.'/') !!}/"+banque_id;
                    });
                });
            </script>
               <a href="{!! url('versements_print/'.$type.'/'.$annee_mois.'/'.$banque_id) !!}" 
                    class="btn btn-info">
                    {!! ($banque_id=="ALL")?"Imprimer tous les bordereaux":"Imprimer un borderau" !!}</a>

         </div>

    </div>
    <br/>

    <div class="col-sm-11">
        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        @if($banque_id=="ALL")
                        <th width='10%'>Banque</th>
                        @endif
                        <th width='1%' nowrap>N°BENEF</th>
                        <th>NOM</th>
                        <th>PRENOM</th>
                        <th width='1%'>NAISS</th>
                        <th width='10%'>TYPE</th>
                        <th width='10%'>RAPPEL</th> 
                        <th width='10%'>MNT&nbsp;CFP</th> 
                        <th width='10%'>MNT&nbsp;EUR</th>
                        <th width='10%'>COMPTE</th>
                    </tr>
                </thead>
     
                <tbody>
                @foreach ($versements_b as $versement_b)
                <?php
                    $montant_cfp=$versement_b->montant_r+$versement_b->montant_c;
                    $montant_eur=round(0.00838*$montant_cfp,2);
                ?>
                <tr>
                    @if($banque_id=="ALL")
                    <td>{!! $versement_b->banque_nom !!}</td>
                    @endif
                    <td style="color:grey">{!! $versement_b->id !!}</td>
                    <td>{!! $versement_b->nom_beneficiaire !!}</td>
                    <td>{!! $versement_b->prenom_beneficiaire !!}</td>
                    <td>{!! $versement_b->naissance_beneficiaire !!}</td>
                    <td align="center">{!! $versement_b->ret_type !!}</td>
                    <td align="center">{!! number_format($versement_b->montant_r,0,","," ") !!}</td>
                    <td align="right">{!! number_format($montant_cfp,0,","," ") !!}</td>
                    <td align="right">{!! number_format($montant_eur,2,","," ")."€" !!}</td>
                    <td>{!! $versement_b->compte !!}</td>
                </tr>
                    @endforeach
                </tbody>
     
            </table>
        </div>
    </div>
</div>



@endif

{!! Form::close() !!}

</body></html>




