@include('forms.fbncheader')
@include('forms.fdatatables')

@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!}
    {!! Html::style('css/jquery.fancybox-buttons.css') !!}
@stop


    <div class="col-lg-max container-fluid col-lg-offset-1 bg-success alert">
        <div class="col-xs-2">
           {!! Html::image("img/".$user->getIconeStatut($type), "",
            array( 'maxwidth' => '20%','width' => '50%' )) !!}
        </div>
        <div class="col-xs-10">
            <h1>{!! "Versement définitifs des ".$user->getTitreStatut($type) !!}</h1>
        </div>

        <div class="col-xs-2" style="padding-top:10px">
                {!! Form::label('brd', "Numéro d'imprimé :") !!}
            </div>
            <div class="col-xs-2">
                {!! Form::select('num_imp',
                    $liste_num_imp,
                    $num_imp,
                    [
                        'id' => 'num_imp','class' => 'form-control selectpicker show-tick',
                        'data-width' => "90%",'style' => 'font-weight:bold;'
                    ]
                )
                !!}
                <script>
                    $(document).ready(function() {
                        $('#num_imp').on('change', function() {
                            location.href="{!! url('/versements/'.$type) !!}/"
                                +$('#num_imp').val();
                        });
                    });
                </script>
            </div>
    </div>

    <div class="col-lg-max  container-fluid col-lg-offset-1" style="padding-top:20px">
    @if($type!="")
        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>N°Emp</th>
                        <th >Bénéficiaire</th>
                        <th width='1%'>NbEnf{!! ($type!="RET")?" Considérés":"" !!}</th>
                        <th width='1%'>Naissance</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Type</th>
                        @if($type=="RET")
                        <th width='1%'>RetType</th>
                        <th width='1%'>RetDate</th>
                        <th width='1%'>RetNum</th>
                        @endif
                        <!-- <th width='1%' nowrap>N°IMP</th> -->
                        <th width='1%'>Rappel</th>
                        <th width='1%'>Calcul</th>
                        <th width='1%'>Montant</th>
                        <th width='10%'>Banque</th>
                        <th width='10%'>Compte</th>
                        <th>Obs</th>
                    </tr>
                </thead>


                <tbody>
                @foreach ($versements as $versement)
                <?php
                    $beneficiaire=App\Models\Beneficiaire::find($versement->benum);
                ?>

                <tr>
                    <td style="color:grey">{!! $versement->benum !!}</td>
                    <td style="color:grey">{!! $versement->sonum !!}</td>
                    <td><a href="{!! url('tiers/beneficiaires/'.$versement->benum) !!}"
                        class="" target="_blank">
                        {!! $versement->nom_beneficiaire." ".$versement->prenom_beneficiaire !!}</td>
                        </a>
                    <td>
                        {!! $versement->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants) !!}
                    </td>
                    <td>{!! $versement->naissance_beneficiaire !!}</td>
                    <td align="center">{!! $versement->statut_beneficiaire !!}</td>
                    <td align="center">{!! $versement->type !!}</td>
                    @if($type=="RET")
                    <td align="center">{!! $versement->ret_type !!}</td>
                    <td align="center">{!! $versement->ret_date !!}</td>
                    <td align="center">{!! $versement->ret_num !!}</td>
                    @endif
                    <!-- <td align="center">{!! $versement->num_imp !!}</td> -->
                    <td align="right" nowrap>{!! number_format($versement->montant_r,0,","," ")!!}</td>
                    <td align="right" nowrap>{!! number_format($versement->montant_c,0,","," ") !!}</td>
                    <td align="right" style="font-weight:bold;" class="bg-danger" nowrap>{!! number_format($versement->montant,0,","," ") !!}</td>
                    <td>{!! $versement->banque_nom !!}</td>
                    <td>{!! $versement->compte !!}</td>
                    <td>{!! $versement->obs_vers !!}</td>
                </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    @endif


<p>
    <div class='form-group form-horizontal'>
        @if($type!="")
            <div class="col-md-2">
                    <a href="{!! url('versements_print/'.$type.'/'.$num_imp) !!}"
                        class="btn btn-info"  target="_blank">Imprimer le borderau</a>
            </div>

            @if($user->can("VER_EXP") || $user->HasRole("ADMINISTRATEUR"))


            <div class="col-md-3">
                <a href="{!! url('versements_export_fichier_complet/'.$type.'/'.$num_imp) !!}"
                    class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
            </div>
<!--
            <div class="col-md-2">
                    <a disabled href="{!! url('versements_export_fichier/'.$type.'/'.$num_imp) !!}"
                        class="btn btn-danger"  target="_blank">Générer le fichier BWF</a>
            </div>

            <div class="col-md-2">
                    <a disabled href="{!! url('versements_export_fichier_BWF_TP/'.$type.'/'.$num_imp) !!}"
                        class="btn btn-danger"  target="_blank">Générer le fichier BWF/DFiP</a>
            </div>

            <div class="col-md-2">
                    <a disabled href="{!! url('versements_export_fichier_TP/'.$type.'/'.$num_imp) !!}"
                        class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
            </div>
        -->
            @endif
        @endif
    </div>
</p>


</body></html>

{!! Html::script('js/magicsuggest.js') !!}
{!! Html::script('js/jquery.fancybox.js') !!}
{!! Html::script('js/jquery.dataTables.editable.js') !!}

@include('forms.fdatatables_script')

<script>
    $("._box").fancybox({
        //fitToView   : true,
        width       : '85%',
        height      : '85%',
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
    });
</script>
