@include('forms.fbncheader_nomenu')
@include('forms.fdatatables')

<div class="col-lg-max col-lg-offset-1">
    <h2><i class="fa fa-employeurs"></i><small>Versements de l'Employeur </small>{!! $employeur->nom !!}</h2>
    <br/>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>Montant</th>
                        <th >Date</th>
                        <th width='5%'>Banque</th> 
                        <th width='1%'>Compte</th>
                        <th width='1%'>Type</th>
                        <th width='1%'>Observations</th>
                        <th width='120px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($versements as $versement)
                <tr>
                    <td>{!! $versement->id !!}</td>
                    <td>{!! $versement->montant
                    <td>{!! $versement->date !!}</td>
                    <td>{!! $versement->banque</td>
                    <td>{!! $versement->compte !!}</td>
                    <td>{!! $versement->type !!}</td>
                    <td>{!! $versement->obervations !!}</td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>

@if($user->can("COT_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('recouvrement/versement_annee/'.$employeur->id) !!}" 
            class="btn btn-success"
            target="_blank">Gestion des Versements</a></h4>
    </div> 
@endif

</div>

</body></html>


<script>
$(document).ready(function() {
    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
</script>