@include('forms.fbncheader')
@include('forms.fdatatables')

@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
@stop


    <div class="col-lg-max container-fluid col-lg-offset-1 bg-info alert">
        <div class="col-xs-2">
           {!! Html::image("img/".$user->getIconeStatut($type), "", 
            array( 'maxwidth' => '20%','width' => '50%' )) !!} 
        </div>
        <div class="col-xs-10">
            <h1>{!! "Versement en préparation des ".$user->getTitreStatut($type) !!}</h1>
        </div>
    </div>

    <div class="col-lg-max  container-fluid col-lg-offset-1" style="padding-top:20px">
    @if($type!="")

    @if ($error_compte>0)
            <div class='bg-danger alert'>
            @if($error_compte==1)
                {!! "Attention : $error_compte compte bancaire est en anomalie !" !!}
            @else
                {!! "Attention : $error_compte comptes bancaires sont en anomalie !" !!}
            @endif
        </div>
    @endif
    
        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>N°Emp</th>
                        <th >Bénéficiaire</th>
                        <th width='1%'>NbEnf{!! ($type!="RET")?" Considérés":"" !!}</th>
                        <th width='1%'>Naissance</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Type</th>
                        @if($type=="RET")
                        <th width='1%'>RetType</th>
                        <th width='1%'>RetDate</th>
                        <th width='1%'>RetNum</th>
                        @endif
                        <!-- <th width='1%' nowrap>N°IMP</th> -->
                        <th width='1%'>Rappel</th>
                        <th width='1%'>Calcul</th>
                        <th width='1%'>Montant</th>
                        <th width='10%'>Banque</th>
                        <th width='10%'>Compte</th>
                        <th>Obs</th>
                    </tr>
                </thead>
     

                <tbody>
                @foreach ($versements_b as $versement_b)
                <?php
                    $beneficiaire=App\Models\Beneficiaire::find($versement_b->benum);
                ?>
                
                <tr>
                    <td style="color:grey">{!! $versement_b->benum !!}</td>
                    <td style="color:grey">{!! $versement_b->sonum !!}</td>
                    <td><a href="{!! url('tiers/beneficiaires/'.$versement_b->benum) !!}" 
                        class="" target="_blank">
                        {!! $versement_b->nom_beneficiaire." ".$versement_b->prenom_beneficiaire !!}</td>
                        </a>
                    <td>
                        {!! $versement_b->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants) !!}
                    </td>
                    <td>{!! $versement_b->naissance_beneficiaire !!}</td>
                    <td align="center">{!! $versement_b->statut_beneficiaire !!}</td>
                    <td align="center">{!! $versement_b->type !!}</td>
                    @if($type=="RET")
                    <td align="center">{!! $versement_b->ret_type !!}</td>
                    <td align="center">{!! $versement_b->ret_date !!}</td>
                    <td align="center">{!! $versement_b->ret_num !!}</td>
                    @endif
                    <!-- <td align="center">{!! $versement_b->num_imp !!}</td> -->
                    <td align="right" nowrap>{!! number_format($versement_b->montant_r,0,","," ")!!}</td>
                    <td align="right" nowrap>{!! number_format($versement_b->montant_c,0,","," ") !!}</td>
                    <td align="right" style="font-weight:bold;" class="bg-danger" nowrap>{!! number_format($versement_b->montant,0,","," ") !!}</td>
                    <td>{!! $versement_b->banque_nom !!}</td>
                    <td 
                        {!! (!$versement_b->CompteOK)?'class="bg-danger alert mark" style="color:red;text-weight:bold"':'' !!}>
                        {!! $versement_b->compte !!}
                        {!! (!$versement_b->CompteOK)?' !!ANOMALIE!!':'' !!}
                    </td>
                    <td>{!! $versement_b->obs_vers !!}</td>
                    

                </tr>
                    @endforeach
                </tbody>
     
            </table>
        </div>
    @endif


<p>
    <div class='form-group form-horizontal'>
        @if($type!="")
            <div class="col-xs-3">
                    <a href="{!! url('versements_brouillon_print/'.$type) !!}" 
                        class="btn btn-info"  target="_blank">Imprimer le borderau</a>
            </div>
        @endif
    </div>
</p>


</body></html>

{!! Html::script('js/magicsuggest.js') !!}
{!! Html::script('js/jquery.fancybox.js') !!}
{!! Html::script('js/jquery.dataTables.editable.js') !!} 

@include('forms.fdatatables_script')

<script>
    $("._box").fancybox({
        //fitToView   : true,
        width       : '85%',
        height      : '85%',
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
    });
</script>
