@extends('layouts.master')
 
@section('title') Mise à jour d'une fiche versement @stop
 
@section('content')
 


<div class="col-lg-10 col-lg-offset-1">
    <h1>{!! $titre_versement !!}</h1>

    @if(count($enfants)==0)
        <div class="bg-danger alert">
            Aucun enfant n'est actuellement concerné par cette opération.
        </div>
    @else
    <div class="">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>Id</th>
                    <th>Nom</th>
                    <th width='1%'>Sexe</th>
                    <th width='1%'>Date de naissance</th>
                    <th width='1%'>Age</th>
                    <th width='1%'>Certificat</th>
                    <th width='1%'>Nouveau Certificat</th>
                    <th width='10%'>Responsable</th>
                    <th width='1%'>Statut Resp.</th>
                    <th width='10%'>Conjoint</th>
                    <th width='1%'>Statut Conj.</th>
                    <th width='185px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($enfants as $enfant)
                <?php
                    $class=($enfant->NewCertificat==$enfant->certif)?'success':'danger';

                ?>
                <tr>
                    <td>{!! str_pad($enfant->id, 6, "0", STR_PAD_LEFT) !!}</td>
                    <td nowrap>{!! $enfant->NomCompletReduit  !!}</td>
                    <td nowrap>{!! $enfant->sexe !!}</td>
                    <td nowrap align="center">{!! $enfant->datenais !!}</td>
                    <td nowrap align="center">{!! $enfant->age !!}</td>
                    <td nowrap align="center">{!! $enfant->certif !!}</td>
                    <td nowrap align="center" class="bg-{!! $class !!}">{!! $enfant->NewCertificat !!}</td>
                    <td nowrap>{!! $enfant->nom_parent1_reduit !!}</td>
                    <td nowrap align="center">{!! $enfant->statut_parent1  !!}</td>
                    <td nowrap>{!! $enfant->nom_parent2_reduit !!}</td>
                    <td nowrap align="center">{!! $enfant->statut_parent2  !!}</td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
        @endif
    </div>

</div>
@stop









