@extends('layouts.master')

@section('title')Historique des versements @stop

@section('styles')
    <!-- Datatable -->
    {!! Html::style('css/dataTables.bootstrap.css'); !!} 
    {!! Html::style('css/buttons.bootstrap.css'); !!} 
@stop



@section('content')
<div class="col-lg-max">
    <h1><i class="fa fa-employeurs"></i>Historique des versements</h1>
        <div class="table-responsive">
            <table id="_table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>Montant</th>
                        <th width='1%'>Date</th>
                        <th width='14%'>Banque</th>
                        <th width='1%'>Compte</th> 
                        <th width='1%'>Mode de paiement</th>
                        <th width='1%'>Type</th>
                        <th width='1%'>DateValid</th>
                        <th width='13%'>Soc.</th>
                        <th width='1%'>MontantC.</th>
                        <th width='1%'>MontantR.</th>
                        <th width='1%'>NumImp</th>
                        <th width='1%'>RetType</th>
                        <th width='1%'>RetDate</th>
                        <th width='1%'>RetNum</th>
                        <th width='60%'>Observations</th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($versements_hg as $versement_hg)
                    <tr>
                        <td style="color:grey">{!! $versement_hg->id !!}</td>
                        <td style="color:grey">{!! $versement_hg->montant !!}</td>
                        <td style="color:grey">{!! $versement_hg->date !!}</td>
                        <td style="color:grey">{!! $versement_hg->BanqueNom !!}</td>
                        <td style="color:grey">{!! $versement_hg->compte !!}</td>
                        <td style="color:grey">{!! $versement_hg->mode_pmt !!}</td>
                        <td style="color:grey">{!! $versement_hg->type !!}</td>
                        <td style="color:grey">{!! $versement_hg->date_valid !!}</td>
                        <td style="color:grey">{!! $versement_hg->nom_court_employeur !!}</td>
                        <td style="color:grey">{!! $versement_hg->montant_c !!}</td>
                        <td style="color:grey">{!! $versement_hg->montant_r !!}</td>
                        <td style="color:grey">{!! $versement_hg->num_imp !!}</td>
                        <td style="color:grey">{!! $versement_hg->ret_type !!}</td>
                        <td style="color:grey">{!! $versement_hg->ret_date !!}</td>
                        <td style="color:grey">{!! $versement_hg->ret_num !!}</td>
                        <td style="color:grey">{!! $versement_hg->obs_vers !!}</td>
                    </tr>
                    @endforeach
                </tbody>
     
            </table>
        </div>

</div>

</body></html>
@stop

@section('scripts')
    <!-- Datatable  -->
    {!! Html::script('js/jquery.dataTables.js'); !!}
    {!! Html::script('js/dataTables.bootstrap.js'); !!}
    <!-- Datatable Button --> 
    {!! Html::script('js/dataTables.buttons.js'); !!}
    {!! Html::script('js/buttons.bootstrap.js'); !!}
    {!! Html::script('js/buttons.html5.js'); !!}
    {!! Html::script('js/buttons.print.js'); !!}
    {!! Html::script('js/jszip.min.js'); !!}
    {!! Html::script('js/pdfmake.min.js'); !!}
    {!! Html::script('js/vfs_fonts.js'); !!}
    {!! Html::script('js/buttons.colVis.min.js'); !!}

    {!! Html::script('js/moment.min.js'); !!}
    {!! Html::script('js/datetime-moment.js'); !!}

<script>
$(document).ready(function() {
   $.fn.dataTable.moment('D/M/YYYY');

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: true,
        bInfo: true,
        bFilter: true,
        deferRender:    true,
        //scrollY:        400,
        scrollCollapse: false,
        scroller:       false,

        iDisplayLength:10,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
            },
            dom: "<'row'<'col-sm-3 text-left'f><'col-sm-4'><'col-sm-5 text-center'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                {extend: 'pdf',exportOptions: {columns: ':visible'} },
                {extend: 'print',exportOptions: {columns: ':visible'} },
                'colvis'
            ],
          
            columnDefs: [ {
                targets: [5,6,8,12,13,14],
                visible: false
            } ]

        } );


} );
</script>

@stop
