@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-employeurs"></i>ddEmployeurs</small></h1>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th>Nom</th>
                    <th width='5%'>Tel</th>
                    <th width='5%'>Ile</th>
                    <th width='5%'>Responsable</th>
                    <th width='5%'>Statut</th>
                    <th width='150px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($employeurs as $employeur)
                <tr>
                    <td>{!! str_pad($employeur->id,4,'0',STR_PAD_LEFT)  !!}</td>
                    <td nowrap>{!! $employeur->nom !!}</td>
                    <td nowrap>{!! $employeur->tel !!}</td>
                    <td nowrap>{!! $employeur->ile !!}</td>
                    <td nowrap>{!! $employeur->responsable !!}</td>
                    <td nowrap>{!! $employeur->statut !!}</td>
                    <td nowrap>
                    @if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="../tiers/employeurs/{!! $employeur->id !!}" class="btn btn-warning pull-left" style="margin-right: 3px;">Consulter</a>
                    @endif 
                    @if($user->can("EMP_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="../tiers/employeurs/{!! $employeur->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                    @endif 
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
@if($user->can("EMP_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="./employeurs/create" class="btn btn-success">Ajouter un Employeur</a></h4>
    </div> 
@endif

</div>

</body></html>


@include('forms.fdatatables_script')