@extends('layouts.master_soft')
 
@section('title') Controle @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h3><i class='fa fa-banque'></i>Controle N°{!! $controle->id !!}</h3>
 
    {!! Form::model($controle, [
        'url' => '/uploadfile',
        'files'=>'true',
        'controle' => 'form',
        'enctype' => 'multipart/form-data',
        'class' => 'form-horizontal'
        ]) !!}



    <div class="tab-content">
        {!! Form::hidden('id',$controle->id); !!}

        <div class="form-group">
            <div class="col-xs-5">
                {!! Form::label('sonum', 'Employeur') !!}
                <div class="input-group">
                    <div class="input-group-addon" id="ref_employeur">{!! $controle->sonum !!}</div>
                    {!! Form::text('sonum',$controle->nom_employeur, ['disabled' => 'true','class' => 'form-control']) !!}
                </div>
            </div>

            <div class="col-xs-2">
                {!! Form::label('date_cont', 'Date du contrôle') !!}
                <div class='input-group date' id='datepicker_date_med'>
                        {!! Form::text('date_cont', $controle->date, ['disabled' => 'true', 'class' => 'form-control']) !!}
                </div>
            </div>
        </div>

        <div class="form-group">

        </div>


        <div class='form-group'>
            <div class="col-md-8">
            {!! Form::label('Fichier', 'Fichier') !!}

            {!! Form::open(array('url' => '/uploadfile','files'=>'true')); !!}
            {!! Form::file('fichier') !!}

            </div>
        </div>


    <div class="col-sm-9">
        <div class='form-group'><br/>
            {!! Form::submit('Télécharger le fichier', 
            ['class' => 'btn btn-primary','onclick'=>'']) !!}
        </div>
    </div>


    {!! Form::close() !!}
    </div>
 
</div>
 

@stop