@extends('layouts.master')


@section('title') Nouvelle fiche controle @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i> Nouveau controle</h1>

    {!! Form::open(['controle' => 'form', 'url' => '/recouvrement/controles', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                <div class="input-group">
                    @if($employeur_id!="") 
                    <div class="input-group-addon" id="ref_employeur">{!! $employeur_id !!}</div>
                    {!! Form::hidden('sonum', $employeur_id ) !!}
                    @endif
                    {!! 
                    Form::select('sonum',$liste_employeur,$employeur_id,
                        [
                            'class' => 'selectpicker show-tick',
                            'id' => 'sonum',
                            'data-width' => "100%",
                            'disabled' => ($employeur_id!="")?'true':'false',
                        ]
                        ) 
                    !!}
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('date_cont', 'Date du contrôle') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_cont'>
                            {!! Form::text('date_cont', '', ['placeholder' => 'Date du contrôle', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_cont').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>



        <div class="form-group">
            <div class="col-md-3">
                    {!! Form::label('agent1', 'Agent1') !!}
                    {!! Form::text('agent1', null, ['placeholder' => 'Agent1','class' => 'form-control']) !!}
            </div>

            <div class="col-md-3">
                    {!! Form::label('agent2', 'Agent2') !!}
                    {!! Form::text('agent2', null, ['placeholder' => 'Agent2','class' => 'form-control']) !!}
            </div>
        </div>



        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('date_valid', 'Date de validation') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_valid'>
                            {!! Form::text('date_valid', '', ['placeholder' => 'Date de validation', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_valid').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('observations', 'Observations') !!}
            {!! Form::textarea('observations', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>



</div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>

@stop