@extends('layouts.master')


@section('title') Nouvelle fiche cotisation @stop

@section('content')

<div class="col-md-max col-md-offset-1">

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i>Nouvelle cotisation</h1>

    {!! Form::open(['cotisation' => 'form', 'url' => '/recouvrement/cotisations', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">
        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! Form::text('employeur', $employeur->id."  ".$employeur->nom, ['class' => 'form-control']) !!}
                {!! Form::hidden('sonum', $employeur->id, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('date', 'Date d\'entrée') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date'>
                            {!! Form::text('date', date('d/m/Y'), ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('type_ope', 'Opération') !!}
                {!!
                Form::select(
                    'type_ope',$types_operations,
                    '',
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%",
                    ]
                )

                !!}
            </div>



            <div class="col-md-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::select('exercice',$exercices,date('Y'),
                        [
                            'id' => 'exercice_id','class' => 'form-control selectpicker',
                            'data-width' => "100%",'style' => 'font-weight:bold;'
                        ]
                    )
                    !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-xs-2">
                {!! Form::label('type_cotis', 'Type') !!}
                {!!
                Form::select(
                    'type_cotis',$types_cotisation,
                    '',
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%"
                        ,'placeholder' => 'Choisissez un type'
                    ]
                )
                !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('nbmois', 'Nb mois') !!}
                    {!! Form::text('nbmois', null, ['placeholder' => 'Nb mois','class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('mois', 'Mois de départ') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_mois'>
                            {!! Form::text('mois', '',
                                ['placeholder' => 'Mois de départ', 'id'=>'mois','class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_mois').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>


            <div class="col-md-2">
                    {!! Form::label('nbsal', 'Nb salariés') !!}
                    {!! Form::text('nbsal', null, ['placeholder' => 'Nb salariés','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('bdx', 'N°Bordereau') !!}
                    {!! Form::text('bdx', null, ['placeholder' => 'N°bordereau','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('bdx_prive', 'N°Bord.privé') !!}
                    {!! Form::text('bdx_prive', null, ['placeholder' => 'N°bordereau privé','class' => 'form-control']) !!}
            </div>
        </div>




        <div class='form-group'>
            <div class="col-md-7">
            {!! Form::label('observation', 'Observations') !!}
            {!! Form::textarea('observation', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>



    <div class='form-group'>
        <div class='col-md-6'>
            <fieldset >
                <legend class="h4">Cotisation</legend>

                <div class="form-group bg-danger" style="padding:5px">
                    <div class="col-md-2">
                        {!! Form::label('assiette', 'Assiette') !!}
                    </div>
                    <div class="col-md-3" >
                        {!! Form::text('assiette', null, ['placeholder' => 'Assiette','id'=>'assiette'
                            , 'class' => 'form-control','style'=>'text-align:right']) !!}
                    </div>
                    <div class="col-md-2">
                        {!! Form::text('PrcTot', null, ['class' => 'form-control','id'=>'PrcTot'
                            ,'disabled'=>'true','style'=>'text-align:center']) !!}
                    </div>


                    <br/><br/>


                    <div class="col-md-2">
                        {!! Form::label('clr', 'CLR') !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::text('clr', null, [
                            'placeholder' => 'CLR', 'id'=>'CLR','class' => 'form-control',
                            'readonly','style'=>'text-align:right'
                            ]) !!}
                    </div>
                    <div class="col-md-2">
                        {!! Form::text('PrcCLR', null, [
                            'class' => 'form-control','id'=>'PrcCLR','readonly',
                            'style'=>'text-align:center'
                            ]) !!}
                    </div>
                    <div class="col-md-3">
                        <input type='checkbox' value='1' name='box_clr' id='box_clr'/> Sans CLR
                    </div>


                    <br/><br/>


                    <div class="col-md-2">
                        {!! Form::label('ccpf', 'CCPF') !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::text('ccpf', null, ['placeholder' => 'CCPF', 'id'=>'CCPF'
                            ,'readonly', 'class' => 'form-control','style'=>'text-align:right']) !!}

                    </div>
                    <div class="col-md-2">
                        {!! Form::text('PrcCCPF', null, ['class' => 'form-control','id'=>'PrcCCPF'
                            ,'readonly','style'=>'text-align:center']) !!}
                    </div>
                    <div class="col-md-3">
                        <input type='checkbox' value='1' name='box_ccpf' id='box_ccpf'/> Sans CCPF
                    </div>
                </div>


               <div class="form-group bg-info" style="padding:5px">
                    <div class="col-md-2">
                        {!! Form::label('total', 'Total') !!}
                    </div>
                    <div class="col-md-3" >
                        {!! Form::text('total', null, ['class' => 'form-control'
                            ,'id'=>'total'
                            ,'style'=>'text-align:right'
                            ,'readonly']) !!}
                    </div>

                </div>
            </fieldset>
        </div>
    </div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>

    {!! Form::close() !!}

</div>


<?php
/*
$ar = array('apple'=>'AA', 'orange', 1, false, null, true, 3 + 5);
$taux = $taux_CLR;
echo json_encode($taux);
*/
?>

 <script>
    $("#mois").change(function() { set_Taux(); });
    $("#assiette").change(function() { set_Taux(); });
    $("#box_clr").change(function() { set_Taux(); });
    $("#box_ccpf").change(function() { set_Taux(); });


    //Positionne les taux en fonction de l'année
    function set_Taux() {
        var taux_CLR = <?php echo json_encode($taux_CLR) ?>;
        var taux_CPF = <?php echo json_encode($taux_CPF) ?>;
        var statut = <?php echo json_encode($employeur->statut) ?>;
        if(statut=="ASV") taux_CPF=0;

        var exercice=$("#mois").val();
        if(exercice.length<10) return;
        var year=parseInt(exercice.substr(6,4));

        $("#PrcCLR").val("");
        $("#PrcCCPF").val("");
        $("#PrcTot").val("");

        if(taux_CLR[year]) $("#PrcCLR").val(taux_CLR[year]);
        if(statut=="ASV") {
            $("#PrcCCPF").val("Non concerné");
        } else {
            if(taux_CPF[year]) $("#PrcCCPF").val(taux_CPF[year]);
        }

        var t1=parseFloat($("#PrcCLR").val());
        var t2=0;
        if(statut!="ASV") {
            t2=parseFloat($("#PrcCCPF").val());
        }
        if($("#box_clr").is(':checked')) {t1=0;$("#PrcCLR").val(0);}
        if($("#box_ccpf").is(':checked')) {t2=0;$("#PrcCCPF").val(0);}

        $("#PrcTot").val(t1+t2);

        taux_CLR[year];

        calcul();
    }

    //Calcul le total
    function calcul() {
        var t_CLR=($("#PrcCLR").val());
        var t_CCPF=($("#PrcCCPF").val());
        var statut = <?php echo json_encode($employeur->statut) ?>;
        var assiette = $("#assiette").val();
        if(assiette=="")  $("#assiette").val(0);

        var CLR = t_CLR*assiette/100;
        var CCPF = 0;
        var total=0;
        if(statut!="ASV") CCPF = t_CCPF*assiette/100;


        $("#CLR").val(parseInt(CLR));
        if(statut!="ASV") {
            $("#CCPF").val(parseInt(CCPF));
            total=parseInt(CLR+CCPF);
        } else {
            $("#CCPF").val("Non concerné");
            total=parseInt(CLR);
        }


        $("#total").val(total);

        $("#PrcCLR").val($("#PrcCLR").val()+"%");
        if(statut!="ASV") $("#PrcCCPF").val($("#PrcCCPF").val()+"%");
        else $("#PrcCCPF").val("");
        $("#PrcTot").val($("#PrcTot").val()+"%");
    }


    set_Taux();
 </script>
@stop
