@extends('layouts.master')
 
@section('title') Cotisation N°{!! $cotisation->id !!} @stop
 
@section('content')
 
<div class='col-lg-max col-lg-offset-1'  style="margin-top:-20px">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1>Cotisation N°{!! $cotisation->id !!}</h1>
 
    {!! Form::model($cotisation, ['cotisation' => 'form'
        , 'url' => '/recouvrement/cotisations/' . $cotisation->id, 'method' => 'PUT'
            , 'class' => 'form-horizontal']) !!}

    {!! Form::hidden('sonum',$cotisation->sonum) !!}



        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                <div class="input-group">
                    <div class="input-group-addon" id="ref_employeur">
                        {!! $cotisation->sonum !!}
                    </div>
                    {!! Form::text('nom_employeur',$cotisation->nom_employeur, ['readonly','class' => 'form-control']) !!}
                </div>
            </div>

            <div class="col-md-2">
                {!! Form::label('date', 'Date d\'entrée') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date'>
                        {!! Form::text('date', $cotisation->date, ['placeholder' => 'Date', 'class' => 'form-control',
                        $cotisation->VerrouDebit?'readonly':'']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        @if(!$cotisation->VerrouDebit)
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                        @endif
                    </div>
                </div>
            </div>
        </div>



        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('type_ope', 'Opération') !!}
                @if($cotisation->VerrouDebit)
                    {!! Form::text('type_ope',$cotisation->type_ope, 
                    ['readonly','class' => 'form-control']) !!}
                @else
                    {!! 
                    Form::select(
                        'type_ope',$types_operations,
                        $cotisation->type_ope,
                        [
                            'class' => 'selectpicker'
                            ,'data-width' => "100%",
                        ]
                    ) 
                        
                    !!}
                @endif
            </div>
s
            <div class="col-md-5">
                {!! Form::label('encais_compte', 'Compte') !!}
                {!! Form::select('encais_compte',
                    App\Models\MyApp::COMPTES_ENCAISSEMENT,
                    $cotisation->encais_compte,
                    ['placeholder' => 'A définir','class' => 'selectpicker','data-width' => "100%"]
                ) !!}
            </div>
            <div class="col-md-1">
                {!! Form::label('exercice', 'Exercice') !!}
                @if($cotisation->VerrouDebit)
                    {!! Form::text('exercice',$cotisation->exercice, ['readonly','class' => 'form-control']) !!}
                @else
                    {!! Form::select('exercice',$exercices,$cotisation->exercice,
                        [
                            'class' => 'selectpicker show-tick',
                            'id' => 'sonum',
                            'data-width' => "100%",
                        ]
                        ) 
                    !!}
                @endif
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-2">
                {!! Form::label('type_cotis', 'Type') !!}
                @if($cotisation->VerrouDebit)
                    {!! Form::text('type_cotis',$cotisation->type_cotis, 
                    ['readonly','class' => 'form-control']) !!}
                @else
                    {!! 
                    Form::select(
                        'type_cotis',$types_cotisation,
                        $cotisation->type_cotis,
                        [
                            'class' => 'selectpicker'
                            ,'data-width' => "100%",
                            ,'placeholder' => 'Choisissez un type',
                            $cotisation->VerrouDebit?'disabled':''
                        ]
                    )!!}
                @endif       
            </div>


            <div class="col-md-2">
                {!! Form::label('encais_date', 'Date d\'encaissement') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_encais_date'>
                        {!! Form::text('encais_date', $cotisation->encais_date, [
                        'placeholder' => 'Date', 
                        'class' => 'form-control'
                        ]) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        @if(!$cotisation->VerrouDebit)
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_encais_date').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                        @endif
                    </div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('nbmois', 'Nb mois') !!}
                    {!! Form::text('nbmois', $cotisation->nbmois, ['placeholder' => 'Nombre de mois','class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('mois', 'Mois de départ') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_mois'>
                        {!! Form::text('mois', $cotisation->mois, ['placeholder' => 'Mois de départ', 'class' => 'form-control',
                        $cotisation->VerrouDebit?'readonly':''
                        ]) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        @if(!$cotisation->VerrouDebit)
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_mois').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-md-1">
                    {!! Form::label('nbsal', 'Nb salariés') !!}
                    {!! Form::text('nbsal', $cotisation->nbsal, ['placeholder' => 'Nombre de salariés','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('bdx', 'N°Bordereau') !!}
                    {!! Form::text('bdx', null, [
                        'placeholder' => 'Numéro de bordereau',
                        'class' => 'form-control',
                        $cotisation->VerrouDebit?'readonly':'',
                        ]) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('bdx_prive', 'N°Bord. privé') !!}
                    {!! Form::text('bdx_prive', $cotisation->bdx_prive, [
                    'placeholder' => 'Numéro de bordereau privé',
                    'class' => 'form-control',
                    $cotisation->VerrouDebit?'readonly':'',
                    ]) !!}
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
                {!! Form::label('observation', 'Observations') !!}
                {!! Form::textarea('observation', $cotisation->observation, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>


        <div class='form-group col-md-6'>
            <div class="">
                <fieldset class="">
                    <legend class="h4">Cotisation</legend>
                    <div class="form-group bg-warning"  style="padding:5px">
                        <div class="col-md-3">
                                {!! Form::label('compte', 'Compte') !!}
                                {!! Form::text('compte', str_replace(' ','',$cotisation->compte), ['placeholder' => 'Compte','class' => 'form-control']) !!}
                        </div>
                        <div class="col-md-4">
                                {!! Form::label('typepmt', 'Modalité de paiement') !!}
                                {!! 
                                Form::select(
                                    'typepmt',
                                    [
                                        ''=>' '
                                        ,'A'=>'Autre'
                                        ,'B' => 'Banque'
                                        ,'E' => 'Espèce'
                                        ,'T' => 'Trésor'
                                        ,'V' => 'Virement'
                                        ,'P' => 'Prélèvement automatique'
                                        ,'€' => 'Euro'
                                        ,'N' => 'Nul'
                                        ],
                                    $cotisation->typepmt,
                                    [
                                        'class' => 'selectpicker'
                                        ,'data-width' => "100%"
                                    ]
                                )  
                                !!}
                       </div>

                        <div class="col-md-4">
                            {!! Form::label('date_depot', 'Date de dépôt') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot'>
                                    {!! Form::text('date_depot', $cotisation->date_depot, 
                                        ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group bg-danger" style="padding:5px">
                        <div class="col-md-2">
                            {!! Form::label('assiette', 'Assiette') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('assiette', null, [
                                    'placeholder' => 'Assiette'
                                    , 'class' => 'form-control','style'=>'text-align:right'
                                    ,'id'=>'assiette',
                                    $cotisation->VerrouDebit?'readonly':''
                                ]) 
                                !!} 
                        </div>
                        <div class="col-md-2">
                            {!! Form::text('PrcTot', null, ['class' => 'form-control'
                                ,'disabled'=>'true','style'=>'text-align:center'
                                ,'id'=>'PrcTot']) !!} 
                        </div>
                        <br/><br/>

                        <div class="col-md-2">
                            {!! Form::label('clr', 'CLR') !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text('clr', null, ['placeholder' => 'CLR'
                                ,'readonly', 'class' => 'form-control'
                                ,'style'=>'text-align:right','id'=>'CLR']) !!} 
                        </div>
                        <div class="col-md-2">
                            {!! Form::text('PrcCLR', null, ['class' => 'form-control'
                                ,'readonly','style'=>'text-align:center','id'=>'PrcCLR']) !!} 
                        </div>
                        <div class="col-md-3">
                            <input 
                                {!! $cotisation->VerrouCredit?'disabled':'' !!} 
                                type='checkbox' value='1' name='box_clr' id='box_clr'
                            />
                             Sans CLR
                        </div>
                        <br/><br/>

                        <div class="col-md-2">
                            {!! Form::label('ccpf', 'CCPF') !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text('ccpf', null, ['placeholder' => 'CCPF'
                                ,'readonly', 'class' => 'form-control'
                                ,'style'=>'text-align:right','id'=>'CCPF']) !!} 
                        </div>
                        <div class="col-md-2">
                            {!! Form::text('PrcCCPF', null, ['class' => 'form-control'
                                ,'readonly','style'=>'text-align:center','id'=>'PrcCCPF']) !!} 
                        </div>
                        <div class="col-md-3">
                            <input {!! $cotisation->VerrouCredit?'disabled':'' !!} type='checkbox' value='1' name='box_ccpf' id='box_ccpf'/>
                             Sans CCPF
                        </div>
                    </div>


                   <div class="form-group bg-info" style="padding:5px">
                        <div class="col-md-2">
                            {!! Form::label('total', 'Total') !!}
                        </div>
                        <div class="col-md-5" >
                            {!! Form::text('total', null, ['class' => 'form-control'
                                ,'style'=>'text-align:right','readonly','id'=>'total']) !!} 
                        </div>
                        <br/><br/>
                        <div class="col-md-2">
                            {!! Form::label('credit', 'Règlement') !!}
                        </div>


                        <div class="col-md-5" >
                                {!! Form::text('credit', null, ['class' => 'form-control'
                                ,'style'=>'text-align:right','id'=>'credit',
                                $cotisation->VerrouCredit?'readonly':''
                                ]) !!} 
                        </div>

                        <!--
                        @if ($cotisation->credit>0)
                        <div class="col-sm-2">
                            <a href="{!! url('cotisations_recu/'.$cotisation->id) !!}" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-warning" 
                            target="_blank">Imprimer le reçu</a>
                        </div>
                        @endif
                    -->
                    </div>
                </fieldset>
            </div>
        </div>



        <div class="col-md-9">
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>


        {!! Form::close() !!}

</div>
 

<script>
    $("#mois").change(function() { set_Taux(); });
    $("#assiette").change(function() { set_Taux(); });
    $("#box_clr").change(function() { set_Taux(); });
    $("#box_ccpf").change(function() { set_Taux(); });


    //Positionne les taux en fonction de l'année
    function set_Taux() {
        var taux_CLR = <?php echo json_encode($taux_CLR) ?>;
        var taux_CPF = <?php echo json_encode($taux_CPF) ?>;
        var statut = <?php echo json_encode($employeur->statut) ?>;
        
        var exercice=$("#mois").val();
        if(exercice.length<10) return;
        var year=parseInt(exercice.substr(6,4));

        $("#PrcCLR").val("");
        $("#PrcCCPF").val("");
        $("#PrcTot").val("");

        if(taux_CLR[year]) $("#PrcCLR").val(taux_CLR[year]);
        if(statut=="ASV") {
            $("#PrcCCPF").val("Non concerné");
        } else {
            if(taux_CPF[year]) $("#PrcCCPF").val(taux_CPF[year]);
        }

        var t1=parseFloat($("#PrcCLR").val());
        var t2=0;
        if(statut!="ASV") {
            t2=parseFloat($("#PrcCCPF").val());
        }

        if($("#box_clr").is(':checked')) {t1=0;$("#PrcCLR").val(0);}
        if($("#box_ccpf").is(':checked')) {t2=0;$("#PrcCCPF").val(0);}

        $("#PrcTot").val(t1+t2);
        $("#PrcTot").val(t1+t2);

        taux_CLR[year];

        calcul();
        return;
    }

    //Calcul le total
    function calcul() {
        var t_CLR=($("#PrcCLR").val());
        var t_CCPF=($("#PrcCCPF").val());
        var statut = <?php echo json_encode($employeur->statut) ?>;

        var assiette = $("#assiette").val();
        if(assiette=="")  $("#assiette").val(0);

        var CLR = t_CLR*assiette/100;
        var CCPF = 0;
        var total=0;
        if(statut!="ASV") CCPF = t_CCPF*assiette/100;

        $("#CLR").val(parseInt(CLR));
        if(statut!="ASV") {
            $("#CCPF").val(parseInt(CCPF));
            total=parseInt(CLR+CCPF);
        } else {
            $("#CCPF").val("Non concerné");
            total=parseInt(CLR);
        }



        $("#total").val(total);

        $("#PrcCLR").val($("#PrcCLR").val()+"%");
        if(statut!="ASV") $("#PrcCCPF").val($("#PrcCCPF").val()+"%");
        else $("#PrcCCPF").val("");
        $("#PrcTot").val($("#PrcTot").val()+"%");
    }

    if($("#CLR").val()==0) {$("#box_clr").prop( "checked", true );$("#PrcCLR").val(0);}
    if($("#CCPF").val()==0) {$("#box_ccpf").prop( "checked", true );$("#PrcCCPF").val(0);}
    set_Taux();
</script>

@stop