@extends('layouts.master')
 
@section('title') Cotisation N°{!! $cotisation->id !!} @stop
 
@section('content')
 
<div class='col-lg-max col-lg-offset-1'  style="margin-top:-20px">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1>Encaissement de la Cotisation N°{!! $cotisation->id !!}</h1>
 
    {!! Form::model($cotisation, ['cotisation' => 'form'
        , 'url' => '/recouvrement/cotisations_encaiss/' . $cotisation->id, 'method' => 'PUT'
            , 'class' => 'form-horizontal']) !!}

    {!! Form::hidden('sonum',$cotisation->sonum) !!}
    {!! Form::hidden('origine',$origine) !!}



        <div class="form-group">
            <div class="col-xs-5">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! Form::text('nom_employeur',$cotisation->nom_employeur, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('date', 'Date d\'entrée') !!}
                {!! Form::text('date',$cotisation->date, ['readonly','class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::text('exercice', $cotisation->exercice, ['readonly','class' => 'form-control']) !!}
            </div>
            <div class="col-xs-1">
                {!! Form::label('type_cotis', 'Type') !!}
                {!! Form::text('type_cotis', $cotisation->type_cotis, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-2">
                    {!! Form::label('nbmois', 'Nb mois') !!}
                    {!! Form::text('nbmois', $cotisation->nbmois, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('mois', 'Mois de départ') !!}
                {!! Form::text('mois', $cotisation->mois, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-1">
                    {!! Form::label('nbsal', 'NbSal.') !!}
                    {!! Form::text('nbsal', $cotisation->nbsal, ['readonly','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-xs-1">
                    {!! Form::label('bdx', 'N°Brd') !!}
                    {!! Form::text('bdx', null, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-1">
                    {!! Form::label('bdx_prive', 'N°BrdPri') !!}
                    {!! Form::text('bdx_prive', $cotisation->bdx_prive, ['readonly','class' => 'form-control']) !!}
            </div>


            <div class="col-xs-5">
                {!! Form::label('observation', 'Observations') !!}
                {!! Form::textarea('observation', $cotisation->observation, ['readonly', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>


        <div class='form-group'>
            <div class="col-xs-7">
            <fieldset class="alert bg-success" style="margin-bottom:-10px">
                <div class="col-xs-6">
                    {!! Form::label('encais_date', 'Date d\'encaissement') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_encais_date'>
                            {!! Form::text('encais_date', $cotisation->encais_date, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_encais_date').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                

                <div class="col-xs-5">
                    {!! Form::label('encais_compte', 'Compte') !!}
                    {!! 
                    Form::select(
                        'encais_compte',App\Models\MyApp::COMPTES_ENCAISSEMENT,$cotisation->encais_compte,
                        [   'placeholder' => 'A définir',
                            'class' => 'selectpicker',
                            'data-width' => "100%"
                        ]
                    ) 
                        
                    !!}
                </div>
            </fieldset>
            </div>
        </div>




        <div class='form-group col-xs-6'>
            <div class="">
                <fieldset class="">
                    <legend class="h4">Cotisation</legend>
                    <div class="form-group bg-warning"  style="padding:5px">
                        <div class="col-xs-3">
                                {!! Form::label('compte', 'Compte') !!}
                                {!! Form::text('compte', null, ['readonly','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-4">
                                {!! Form::label('typepmt', 'Type de paiement') !!}
                                {!! Form::text('typepmt', $cotisation->typepmt, ['readonly','class' => 'form-control']) !!}
                       </div>

                        <div class="col-xs-4">
                            {!! Form::label('date_depot', 'Date de dépôt') !!}
                            {!! Form::text('date_depot', $cotisation->date_depot, ['readonly','class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="form-group bg-danger" style="padding:5px">
                        <div class="col-xs-2">
                            {!! Form::label('assiette', 'Assiette') !!}
                        </div>
                        <div class="col-xs-5" >
                            {!! Form::text('assiette', null, 
                                ['readonly','class' => 'form-control','style'=>'text-align:right']) 
                            !!} 
                        </div>
                        <div class="col-xs-3">
                            {!! Form::text('PrcTot', null, ['class' => 'form-control'
                                ,'readonly','style'=>'text-align:center'
                                ,'id'=>'PrcTot']) !!} 
                        </div>
                        <br/><br/>
                        <div class="col-xs-2">
                            {!! Form::label('clr', 'CLR') !!}
                        </div>
                        <div class="col-xs-5">
                            {!! Form::text('clr', null, 
                                ['readonly', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                        <div class="col-xs-3">
                            {!! Form::text('PrcCLR', null, 
                                ['class' => 'form-control','readonly','style'=>'text-align:center']) !!} 
                        </div>
                        <br/><br/>
                        <div class="col-xs-2">
                            {!! Form::label('ccpf', 'CCPF') !!}
                        </div>
                        <div class="col-xs-5">
                            {!! Form::text('ccpf', null, 
                                ['readonly', 'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                        <div class="col-xs-3">
                            {!! Form::text('PrcCCPF', null, 
                                ['class' => 'form-control','readonly','style'=>'text-align:center']) !!} 
                        </div>
                    </div>


                   <div class="form-group bg-info" style="padding:5px">
                        <div class="col-xs-2">
                            {!! Form::label('total', 'Total') !!}
                        </div>
                        <div class="col-xs-5" >
                            {!! Form::text('total', null, 
                                ['class' => 'form-control','style'=>'text-align:right','readonly']) !!} 
                        </div>
                        <br/><br/>
                        <div class="col-xs-2">
                            {!! Form::label('credit', 'Règlement') !!}
                        </div>
                        <div class="col-xs-5" >
                            {!! Form::text('credit', null, 
                                ['class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>

                    </div>
                </fieldset>
            </div>
        


            

        </div>

        <div class="col-xs-9">
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>


        {!! Form::close() !!}

</div>
 


@stop