@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/datepicker3.css') !!}
{!! Html::script('js/bootstrap-datepicker.js') !!} 
<style type="text/css">
    tfoot input {
      width: 100%;
    }
</style>

<div style="background-color:rgba(127,255,212,.2);"  class="col-lg-max container-fluid">

    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    
    <div style="padding-left:0px" class="col-lg-12">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/entreprise_cotisations.png", 
                    "Cotisations", 
                    array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                     
                !!} 
            </div>

            <div class="col-xs-10" style="padding-left:0px;">
                <h2 style="margin-top:2px;">Cotisations encaissées</h2>
            </div>

 
        </div>

        <fieldset class='alert bg-info'>
            <legend style='color:grey;padding:0px;margin:0px'>Filtre</legend>

            <div class="col-xs-10 form-inline">   
                {!! Form::open(['url' => '/recouvrement/cotisation_encaissees_annee/', 'class' => 'form-horizontal', 'method' => 'POST']) !!}
                
                {!! Form::label('exercice', 'Exercice&nbsp;') !!}
                <div class='input-group'>
                    {!! Form::select('exercice',$exercices,$exercice,
                        [
                            'id' => 'exercice_id','class' => 'form-control ',
                            'style' => 'font-weight:bold;'
                        ]
                    ) 
                    !!}
                    <script>
                        $(document).ready(function() {
                            $('#exercice_id').on('change', function() {
                                location.href="{!! url('/recouvrement/cotisation_encaissees_annee/') !!}"
                                    +"/"+$('#exercice_id').val();
                            });
                        });
                    </script>
                    
                </div>

                {!! Form::label('mois_debut', '&nbsp;ou&nbsp;Encaissements&nbsp;du&nbsp;&nbsp;') !!}
                <div class='input-group date' id='datepicker_mois_debut'>
                    {!! Form::text('mois_debut', isset($mois_debut)?$mois_debut:null, ['placeholder' => 'Mois Début'
                        , 'size'=>'8', 'class' => 'form-control']) !!}
                    <span class='input-group-addon'>
                        <span class='glyphicon glyphicon-calendar'></span>
                    </span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_mois_debut').datepicker({
                                format: "dd/mm/yyyy",
                                language: "fr",
                                autoclose: true
                            });
                        });
                    </script>
                </div>
    

                {!! Form::label('mois_fin', 'au',['style'=>'padding:0px;']) !!}
                <div class='input-group date' id='datepicker_mois_fin'>
                    {!! Form::text('mois_fin', isset($mois_fin)?$mois_fin:null, ['placeholder' => 'Mois Fin'
                        , 'size'=>'8','class' => 'form-control']) !!}
                    <span class='input-group-addon'>
                        <span class='glyphicon glyphicon-calendar'></span>
                    </span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_mois_fin').datepicker({
                                format: "dd/mm/yyyy",
                                language: "fr",
                                autoclose: true
                            });
                        });
                    </script>
                </div>

                {!! Form::label('encais_compte', 'Compte') !!}
                 <div class="input-group">
                    {!! Form::select('encais_compte',App\Models\MyApp::COMPTES_ENCAISSEMENT,
                        isset($encais_compte)?$encais_compte:'',
                        ['placeholder'=>'','class' => 'form-control selectpicker',
                            'data-width' => "100%"]
                    ) !!}
                </div>       
                {!! Form::submit('Filtrer', ['class' => 'btn btn-info'])!!}
            </div>

            {!! Form::close() !!}
            <div class="col-xs-10 form-inline">  
                <div class='form-group h5'>
                    <i>{!! $libelle_filtrage !!}</i>
                </div>
            </div>

        <fieldset>
    </div>


    <div class='col-lg-max' style="padding-top:5px">
        <div class="">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%" 
                >
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>Ex</th>
                        <th>Employeur</th>
                        <th width='1%'>Date</th>
                        <th width='1%'>Pmt</th> 
                        <th width='1%'>CLR</th> 
                        <th width='1%'>CCPF</th>
                        <th width='1%'>Débit</th>
                        <th width='1%'>Crédit</th>
                        <th width='1%'>Mois</th>
                        <th width='1%'>NbMois</th>
                        <th width='1%'>BdPu</th>
                        <th width='1%'>BdPr</th>
                        <th width='1%'>DateEnc</th>
                        <th width='1%'>Compte</th>
                    </tr>
                </thead>    

                <tfoot>
                    <tr style='background-color:lightgrey'>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>                            
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>


                <tbody>
                    @foreach ($cotisations as $cotisation)
                    <tr>
                        <td id='id_{!! $cotisation->id !!}' style="color:grey">
                            @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('recouvrement/cotisations/'.$cotisation->id ) !!}">
                            @endif
                                {!! $cotisation->id !!}
                            @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif
                        </td>
                        <td align="center">{!! $cotisation->exercice !!}</td>
                        <td align="left">{!! $cotisation->NomEmployeur !!}</td>
                        <td align="center">{!! $cotisation->date !!}</td>
                        <td align="center">{!! $cotisation->typepmt !!}</td>
                        <td align="right" nowrap>{!! $cotisation->clr !!}</td>
                        <td align="right" nowrap>{!! $cotisation->ccpf !!}</td>
                        <td align="right" style="font-weight:bold;color:darkred" class="" nowrap>{!! $cotisation->debit !!}</td>
                        <td align="right" style="font-weight:bold;color:darkblue" class="" nowrap>{!! $cotisation->credit !!}</td>
                        <td>{!! $cotisation->mois !!}</td>
                        <td align="center">{!! $cotisation->nbmois !!}</td>
                        <td align="right">{!! $cotisation->bdx !!}</td>
                        <td align="right">{!! $cotisation->bdx_prive !!}</td> 
                        <td align="center">{!! $cotisation->encais_date !!}</td>
                        <td align="center">{!! $cotisation->encais_compte !!}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

         <div class="col-lg-10 form-group" style='font-weight:bold;padding-top:-30px;margin-bottom:50px'>
            <div class="col-xs-2">
                <div>TOTAL&nbsp;CLR&nbsp;:&nbsp;</div>
                <div class='form-control' align='right' id='total_CLR'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;CCPF&nbsp;:&nbsp;
            <div class='form-control' align='right' id='total_CCPF'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;DEBIT&nbsp;:&nbsp;
            <div class='form-control' style='color:red' align='right' id='total_DEBIT'></div>
            </div>

            <div class="col-md-2">TOTAL&nbsp;CREDIT&nbsp;:&nbsp;
            <div class='form-control' style='color:blue' align='right' id='total_CREDIT'></div>
            </div>

            <div class="col-md-2">SOLDE&nbsp;:&nbsp;
            <div class='form-control' style='color:green' align='right' id='total_SOLDE'></div>
            </div>

        </div>
    </div>

    <div class="col-md-4">&nbsp;</div>
</div>

</body></html>


<script>
    $(document).ready(function() {
        $.fn.dataTable.moment('D/M/YYYY');
    
        function format(n, sep) {
            sep = sep || "."; // Default to period as decimal separator
            return n.toLocaleString().split(sep)[0]
                + sep;
        }

        // Setup - add a text input to each footer cell
        $('#_table tfoot th').each( function (i) {
            var title = $('#_table thead th').eq( $(this).index() ).text();
            $(this).html( '<input type="text" placeholder="'+title+'" data-index="'+i+'" />' );
        } );



        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            //deferRender:    true,
            scrollY:        "400px",
            scrollX:        true,
            scrollCollapse: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }
                },

            "footerCallback": function(row, data, start, end, display) {
                var api = this.api(), data;
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };

                total = api.column(5, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total,' ');
                $('#total_CLR').html(total);

                total = api.column(6, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                total=format(total, ' ');
                $('#total_CCPF').html(total);


                total = api.column(7, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_debit=total;
                total=format(total, ' ');
                
                $('#total_DEBIT').html(total);

                total = api.column(8, { page: 'current'}).data().reduce(function(a, b) {
                        return intVal(a) + intVal(b);}, 0);
                var total_credit=total;
                total=format(total, ' ');
                
                $('#total_CREDIT').html(total);

                total=total_credit-total_debit;
                total=format(total, ' ');
                $('#total_SOLDE').html(total);

            },

                "aaSorting": [
                    [0,'desc']
                ],

                "aoColumnDefs": [
                    { "sTypes": "numeric", "aTargets": [ 3 ] },
                    { bSortable: false, aTargets: [11] },
                    { visible: false, targets: [10,11,12] },
                ],


                dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 text-right'i><'col-sm-7'p>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    {extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],


            } );


            // Filter event handler
            $( table.table().container() ).on( 'keyup', 'tfoot input', function () {
                table
                    .column( $(this).data('index') )
                    .search( this.value )
                    .draw();
            } );

            $('#_table').DataTable().draw();

            $(window).resize(function () {
                        $('#_table').DataTable().draw();
            });

    } );
</script>


