@extends('layouts.master')
@section('title')
    Consultation d'une Mise en demeure
@stop
@section('styles')

@stop

@section('content')
 <div class='col-lg-10 col-lg-offset-1' style="margin-top:-20px">
      <h1><i class='fa fa-employeur'></i>Fiche Mise en demeure <small>{!! $med->id !!}</small></h1>
 
    {!! Form::model($med, ['med' => 'form', 'url' => '/recouvrement/med/' . $med->id,  'class' => 'form-horizontal']) !!}

         <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('numero', 'Numéro') !!}
                    {!! Form::text('numero', '', ['placeholder' => 'Numéro','disabled','class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! Form::text('sonum', '', ['disabled','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                {!! Form::label('date_envoi', 'Date d\'envoi') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_envoi'>
                            {!! Form::text('date_envoi', date('j/m/Y'), 
                                ['disabled', 'class' => 'form-control']) !!}
                    </div>
                </div>
            </div>

            <div class='col-md-3'>
                {!! Form::label('motif', 'Motif') !!}
                {!! Form::text('motif',$med->MotifLibelle, ['disabled','class' => 'form-control']) !!}
            </div>

            <div class='form-group'>
                <div class="col-md-1">
                {!! Form::label('nbmois', 'Mois&nbsp;manquants') !!}
                {!! Form::text('nbmois', null, ['disabled','class' => 'form-control']) !!}
                </div>
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Période</legend>
                    <div class="col-md-4">
                        {!! Form::label('periode_deb', 'Début') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_debut'>
                                    {!! Form::text('periode_deb', $med->periode_deb, ['disabled','class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        {!! Form::label('periode_fin', 'Fin') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_periode_fin'>
                                    {!! Form::text('periode_fin', $med->periode_fin, ['disabled','class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
                <fieldset class="">
                    <legend class="h4">Cotisation</legend>

                    <div class="form-group bg-danger" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('cotisations', 'Costisations') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('cotisations', null, 
                                ['disabled','class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>

                        <br/><br/>

                        <div class="col-md-3">
                            {!! Form::label('majorations', 'Majorations') !!}
                        </div>
                        <div class="col-md-3">
                            {!! Form::text('majorations', null, ['disabled',
                                'class' => 'form-control','style'=>'text-align:right']) !!} 
                        </div>
                    </div>


                   <div class="form-group bg-info" style="padding:5px">
                        <div class="col-md-3">
                            {!! Form::label('total', 'Total de la dette') !!}
                        </div>
                        <div class="col-md-3" >
                            {!! Form::text('total',  $med->majorations+$med->cotisations, ['class' => 'form-control'
                                ,'style'=>'text-align:right','disabled'=>'true']) !!} 
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', $med->obs, ['disabled','class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>


<div class="col-sm-9">
    <div class='form-group'>
      
        <a href="{!! url('recouvrement/med_print/')."/".$med->id !!}" 
            class="btn btn-info pull-left" 
            style="margin-right: 3px;"
             target="_blank">
            <span class="glyphicon glyphicon-print">Imprimer</span>
        </a>

    </div>
 </div>

    {!! Form::close() !!}
 
</div>
 
@stop