@extends('layouts.master')


@section('title') saisie d'une cotisation @stop
 
@section('content')
 
<div class="col-sm-max col-sm-offset-1">
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i>Saisie d'un règlement</h1>
    {!! Form::open(['reglement' => 'form', 'url' => '/reglement', 'method' => 'POST', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">   
        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                {!! Form::text('employeur', $employeur->id."  ".$employeur->nom, ['class' => 'form-control']) !!}
                {!! Form::hidden('sonum', $employeur->id, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('date', 'Date') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date'>
                            {!! Form::text('date', date('d/m/Y'), ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('type_ope', 'Opération') !!}
                {!! 
                Form::select(
                    'type_ope',$types_operations,
                    'REG',
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%"
                        ,'disabled'
                    ]
                ) 
                 
                !!}
                {!! Form::hidden('type_ope','REG', 
                    ['readonly','class' => 'form-control']) !!}
            </div>
            <div class="col-md-1">
                {!! Form::label('encais_compte', 'Compte') !!}
                {!! Form::select('encais_compte',
                    [''=>' ','F'=>'F','R' => 'R'],
                    '',
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) !!}
            </div>
            <div class="col-md-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::select('exercice',$exercices,$exercice,
                        [
                            'class' => 'selectpicker show-tick',
                            'id' => 'sonum',
                            'data-width' => "100%",
                        ]
                        ) 
                    !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-2 has-success">
                {!! Form::label('type_cotis', 'Type de cotisation') !!}
                {!! 
                Form::select(
                    'type_cotis',$types_cotisation,'ENC',
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%"
                        ,'disabled'
                    ]
                ) 
                    
                !!}

                {!! Form::hidden('type_cotis','ENC', 
                    ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-md-1">
                    {!! Form::label('nbmois', 'Nb mois') !!}
                    {!! Form::text('nbmois', $nbmois, ['placeholder' => 'Nombre de mois','class' => 'form-control']) !!}
            </div>

            <div class="col-md-3 has-success">
                {!! Form::label('mois', 'Mois de départ') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_mois'>
                            {!! Form::text('mois', $cotisation_model->mois, ['placeholder' => 'Mois de départ', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_mois').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-2 has-success">
                    {!! Form::label('bdx', 'N°Bordereau') !!}
                    {!! Form::text('bdx', $bdx_default, ['placeholder' => 'Numéro de bordereau','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2 has-success">
                    {!! Form::label('bdx_prive', 'N°Bord. privé') !!}
                    {!! Form::text('bdx_prive', $bdx_prive_default, ['placeholder' => 'Numéro de bordereau privé','class' => 'form-control']) !!}
            </div>
            <div class="col-md-1">
                    {!! Form::label('nbsal', 'Nb&nbsp;salariés') !!}
                    {!! Form::text('nbsal', $nbsal, ['placeholder' => 'Nb salariés','class' => 'form-control']) !!}
            </div>

        </div>


        <div class="form-group" >
        <fieldset>
            <legend>Cotisations associées</legend>
            <div class="col-xs-8 bg-info table-responsive">
                <table id="_table" class="table table-condensed table-bordered" style="background-color">
                    <thead>
                        <tr>
                            <th width='1%'>N°</th>
                            <th width='1%'>Exercice</th>
                            <th width='1%'>Date</th>
                            <th width='1%'>Mois</th>
                            <th width='20%'>Assiette</th> 
                            <th width='20%'>CLR</th> 
                            <th width='20%'>CCPF</th>
                            <th width='30%'>Débit</th>
                        </tr>
                    </thead> 
                    <?php $total_clr=0;$total_ccpf=0;$total_debit=0;$total_assiette=0;$liste_cotisations=""; ?>
                    @foreach ($cotisations as $cotisation)
                        <?php
                            $total_assiette+=$cotisation->assiette;
                            $total_clr+=$cotisation->clr;
                            $total_ccpf+=$cotisation->ccpf;
                            $total_debit+=$cotisation->debit;
                            $liste_cotisations.=(($liste_cotisations=="")?"":",").$cotisation->id;
                        ?>
                        <tr style='background-color:white'>
                            <td style="color:grey">{!! $cotisation->id !!}</td>
                            <td class="text-center">{!! $cotisation->exercice !!}</td>
                            <td class="text-center">{!! $cotisation->date !!}</td>
                            <td class="text-center">{!! $cotisation->nbmois !!}</td>
                            <td class="text-right" nowrap>{!! $cotisation->assiette !!}</td>
                            <td class="text-right" nowrap>{!! number_format($cotisation->clr,0,","," ") !!}</td>
                            <td class="text-right" nowrap>{!! number_format($cotisation->ccpf,0,","," ") !!}</td>
                            <td nowrap class="text-right" style="font-weight:bold">
                                {!! number_format($cotisation->debit,0,","," ")." CFP" !!}
                            </td>
                        </tr>
                    @endforeach

                    <footer>
                        <tr>
                            <th class="text-right"></th>
                            <th class="text-right"></th>
                            <th class="text-right"></th>
                            <th class="text-right"></th> 
                            <th class="text-right">{!! number_format($total_assiette,0,","," ") !!}</th>
                            <th class="text-right">{!! number_format($total_clr,0,","," ") !!}</th> 
                            <th class="text-right">{!! number_format($total_ccpf,0,","," ") !!}</th>
                            <th class="text-right danger" style="font-weight:bold">{!! number_format($total_debit,0,","," ")." CFP" !!}</th>
                        </tr>
                    </footer>  
                </table>
            </div>
        </fieldset>
        </div>



        <div class="form-group" >
            <fieldset>
                <legend>Règlements</legend>
                <div class="col-xs-12 bg-success">
                    <div class="form-group has-success" >
                        <div class="col-xs-2">
                            {!! Form::label('credit1', 'Crédit') !!}
                            {!! Form::text('credit1', $total_debit, ['placeholder' => 'Montant 1','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-2">
                                {!! Form::label('compte1', 'Compte') !!}
                                {!! Form::text('compte1', $employeur->compte, ['placeholder' => 'Compte 1','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-1">
                                {!! Form::label('typepmt1', 'Mode') !!}
                                {!! 
                                Form::select(
                                    'typepmt1',$types_paiement,
                                    '',['class' => 'selectpicker','data-width' => "100%",'title'=>'']
                                )      
                                !!}
                       </div>

                        <div class="col-xs-2">
                            {!! Form::label('date_depot1', 'Date de dépôt') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot1'>
                                        {!! Form::text('date_depot1', date('d/m/Y'), ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot1').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-4">
                            {!! Form::label('obs1', 'Observations') !!}
                            {!! Form::textarea('obs1', null, ['placeholder' => 'Observations 1', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>
                

                    <!-- 2 e règlement -->
                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::text('credit2', '', ['placeholder' => 'Montant 2','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-2">
                                {!! Form::text('compte2', null, ['placeholder' => 'Compte','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-1">
                                {!! 
                                Form::select(
                                    'typepmt2',$types_paiement,
                                    '',['class' => 'selectpicker','data-width' => "100%",'title'=>'']
                                )      
                                !!}
                       </div>

                        <div class="col-xs-2">
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot2'>
                                        {!! Form::text('date_depot2', '', ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot2').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-4">
                            {!! Form::textarea('obs2', null, ['placeholder' => 'Observations 2', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>
                


                <!-- 3e règlement -->
                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::text('credit3', '', ['placeholder' => 'Montant 3','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-2">
                                {!! Form::text('compte3', null, ['placeholder' => 'Compte3','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-1">
                            {!! 
                            Form::select(
                                'typepmt3',$types_paiement,
                                '',['class' => 'selectpicker','data-width' => "100%",'title'=>'']
                            )      
                            !!}
                       </div>

                        <div class="col-xs-2">
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot3'>
                                        {!! Form::text('date_depot3', '', ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot3').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-4">
                            {!! Form::textarea('obs3', null, ['placeholder' => 'Observations 3', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>


                <!-- 4e règlement -->
                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::text('credit4', '', ['placeholder' => 'Montant 4','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-2">
                                {!! Form::text('compte4', null, ['placeholder' => 'Compte4','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-1">
                            {!! 
                            Form::select(
                                'typepmt4',$types_paiement,
                                '',['class' => 'selectpicker','data-width' => "100%",'title'=>'']
                            )      
                            !!}
                       </div>
                        <div class="col-xs-2">
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot4'>
                                        {!! Form::text('date_depot4', '', ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot4').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-4">
                            {!! Form::textarea('obs4', null, ['placeholder' => 'Observations 4', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>

                <!-- 5e règlement -->
                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::text('credit5', '', ['placeholder' => 'Montant 5','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-2">
                                {!! Form::text('compte5', null, ['placeholder' => 'Compte5','class' => 'form-control']) !!}
                        </div>
                        <div class="col-xs-1">
                            {!! 
                            Form::select(
                                'typepmt5',$types_paiement,
                                '',['class' => 'selectpicker','data-width' => "100%",'title'=>'']
                            )      
                            !!}
                       </div>
                        <div class="col-xs-2">
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_depot5'>
                                        {!! Form::text('date_depot5','', ['placeholder' => 'Date de dépôt', 'class' => 'form-control']) !!}
                                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                    <script type="text/javascript">
                                        $(function () {
                                            $('#datepicker_date_depot5').datepicker({
                                                format: "dd/mm/yyyy",
                                                language: "fr",
                                                autoclose: true
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-4">
                            {!! Form::textarea('obs5', null, ['placeholder' => 'Observations 5', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>

                </div>
            </fieldset>   
        </div>

        <div class="form-group">
            {!! Form::hidden('credit',$total_debit) !!}
            {!! Form::hidden('assiette',$total_assiette) !!}
            {!! Form::hidden('clr',$total_clr) !!}
            {!! Form::hidden('ccpf',$total_ccpf) !!}
            {!! Form::hidden('liste_cotisations',$liste_cotisations) !!}
            {!! Form::hidden('encais_date','') !!}
            {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
    {!! Form::close() !!}
</div>



@stop