@extends('layouts.master')


@section('title') Nouvelle fiche salaire @stop
 
@section('content')
 
<div class='col-lg-10 col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i> Nouveau salaire</h1>

    {!! Form::open(['salaire' => 'form', 'url' => '/recouvrement/salaires', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        <div class="form-group">

            <div class="col-md-4">
                    {!! Form::label('benum', 'Bénéficiaire') !!}
                    {!! Form::hidden('benum', $beneficiaire->id) !!}
                    <div class="input-group">
                        <div class="input-group-addon" id="ref_beneficiaire">{!! $beneficiaire->id !!}</div>
                        {!! Form::text('benom', $beneficiaire->nom_complet, 
                            ['class' => 'form-control','disabled'=>'true']
                            ) 
                        !!}
                    </div>
            </div>
            <div class="col-md-8">
                    {!! Form::label('sonum', 'Employeur') !!}
                    {!! Form::hidden('sonum', $employeur->id) !!}
                    <div class="input-group">
                        <div class="input-group-addon" name="ref_employeur" id='ref_employeur'>{!! $employeur->id !!}</div>
                        {!! Form::text('employeur_nom', $employeur->nom, 
                            ['class' => 'form-control', 
                                'name'=>"employeur_nom",'id'=>"employeur_nom"]
                            ) 
                        !!}
                    </div>
                <script>
                        $(function() {        
                           $("#employeur_nom").autocomplete({
                                source: "{!! route('autocomplete_employeur') !!}",
                                minLength: 2,
                                select: function(event, ui) {
                                    $('#sonum').val(ui.item.id);
                                    $('#ref_employeur').html(ui.item.id);
                                },
                                change: function( event, ui ) {
                                    var id_nom=ui.item.value.trim();
                                    var nom;
                                    if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                                    $('#employeur_nom').val(nom);
                                    $('#ref_employeur').html(ui.item.id);
                                    $('#sonum').val(ui.item.id);
                                }
                            }); 
                           return;
                        });
                </script>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('annee', 'Année') !!}
                    {!! Form::text('annee', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-4">
                {!! Form::label('dat_ent', 'Date d\'entrée') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_dat_ent'>
                            {!! Form::text('dat_ent', '', ['placeholder' => 'Date d\'entrée', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_dat_ent').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                {!! Form::label('date_sor', 'Date de sortie') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_sor'>
                            {!! Form::text('date_sor', '', ['placeholder' => 'Date de sortie', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_sor').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('jan', 'Janvier') !!}
                    {!! Form::text('jan', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('fev', 'Février') !!}
                    {!! Form::text('fev', null, ['class' => 'form-control ']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('mar', 'Mars') !!}
                    {!! Form::text('mar', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('avr', 'Avril') !!}
                    {!! Form::text('avr', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('mai', 'Mai') !!}
                    {!! Form::text('mai', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('jun', 'Juin') !!}
                    {!! Form::text('jun', null, ['class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('jui', 'Juillet') !!}
                    {!! Form::text('jui', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('aou', 'Aout') !!}
                    {!! Form::text('aou', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('sep', 'Septembre') !!}
                    {!! Form::text('sep', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('oct', 'Octobre') !!}
                    {!! Form::text('oct', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('nov', 'Novembre') !!}
                    {!! Form::text('nov', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-md-2">
                    {!! Form::label('dec', 'Décembre') !!}
                    {!! Form::text('dec', null, ['class' => 'form-control']) !!}
            </div>
        </div>

</div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>

@stop