@extends('layouts.master')
 
@section('title') Mise à jour d'une fiche salaire @stop
 

@section('content')
    @section('styles')
        {!! Html::style('css/jquery.fancybox.css') !!} 
        {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
    @stop

    <div class='col-lg-10 col-lg-offset-1'>
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <h1><i class='fa fa-banque'></i> Mise à jour d'une fiche salaire</h1>
        {!! Form::model($salaire, ['salaire' => 'form', 'url' => '/recouvrement/salaires/' . $salaire->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
            <div class="tab-content">
                <div class="form-group">
                    <div class="col-md-4">
                            {!! Form::label('benum', 'Bénéficiaire') !!}
                            {!! Form::hidden('benum', $salaire->benum) !!}
                            <div class="input-group">
                                <div class="input-group-addon" id="ref_beneficiaire">{!! $salaire->benum !!}</div>
                                {!! Form::text('benom', $salaire->beneficiaire_nom, 
                                    ['class' => 'form-control','disabled'=>'true']
                                    ) 
                                !!}
                            </div>
                    </div>

                    <div class="col-md-4">
                            {!! Form::label('sonum', 'Employeur') !!}
                            {!! Form::hidden('sonum', $employeur->id) !!}
                            <div class="input-group">
                                <div class="input-group-addon" name="ref_employeur" id='ref_employeur'>{!! $employeur->id !!}</div>
                                {!! Form::text('employeur_nom', $employeur->nom, 
                                    ['class' => 'form-control', 
                                        'name'=>"employeur_nom",'id'=>"employeur_nom"]
                                    ) 
                                !!}
                            </div>
                        <script>
                                $(function() {        
                                   $("#employeur_nom").autocomplete({
                                        source: "{!! route('autocomplete_employeur') !!}",
                                        minLength: 2,
                                        select: function(event, ui) {
                                            $('#sonum').val(ui.item.id);
                                            $('#ref_employeur').html(ui.item.id);
                                        },
                                        change: function( event, ui ) {
                                            var id_nom=ui.item.value.trim();
                                            var nom;
                                            if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                                            $('#employeur_nom').val(nom);
                                            $('#ref_employeur').html(ui.item.id);
                                            $('#sonum').val(ui.item.id);
                                        }
                                    }); 
                                   return;
                                });
                        </script>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-1">
                            {!! Form::label('annee', 'Année') !!}
                            {!! Form::text('annee', null, ['class' => 'form-control','readonly']) !!}
                    </div>
                
                    <div class="col-md-4">
                        {!! Form::label('dat_ent', 'Date d\'entrée') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_dat_ent'>
                                {!! Form::text('dat_ent', null, ['placeholder' => 'Date d\'entrée', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_dat_ent').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        {!! Form::label('date_sor', 'Date de sortie') !!}
                        <div class="input-group">
                            <div class='input-group date' id='datepicker_date_sor'>
                                {!! Form::text('date_sor', null, ['placeholder' => 'Date de sortie', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_date_sor').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
                <hr/>
                <div class="form-group">
                    <button type="button" class="btn bt-sm btn-success" onclick="ventiler()">Ventiler un salaire</button>
                    <input type='hidden' id='ventil_active' value="0" />
                    <a href="{!! url('log_salaires/'.$salaire->id) !!} " 
                        class="btn bt-sm btn-warning box_log fancybox.iframe">Historique
                    </a>
                    {!! Form::submit('Enregistrer', ['class' => 'btn bt-sm btn-primary']) !!}
                </div>

                <div class="col-md-12">
                    <table class="table table-condensed table-striped table-bordered">
                        <theader>
                            <tr>
                                <th ></th>
                                <?php $tmois=App\Models\MyApp::MOIS_COURT_LONG; ?>
                                @foreach($tmois as $mois=>$libelle)
                                    <td width='100px'>{!! Form::label($mois, $libelle) !!}</td>
                                @endforeach
                            </tr>
                        </theader>
                        <tbody>
                            <tr>
                                <th>Montant Origine</th>
                                @foreach($tmois as $mois=>$libelle)
                                    <td>{!! Form::text('origine', $salaire->{$mois}, ['class' => 'form-control','disabled']) !!}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <th>Montant</th>
                                @foreach($tmois as $mois=>$libelle)
                                    <td>{!! Form::text($mois, null, ['class' => 'form-control']) !!}</td>
                                @endforeach
                            </tr>
                            <tr>
                            <th>Suspendu</th>
                                @foreach($tmois as $mois=>$libelle)
                                    <td align='center'>
                                        {!! Form::checkbox('box_'.$mois, 1,$salaire->getSuspendu($mois)?1:0
                                            , ['id'=>'box_'.$mois]); !!}
                                    </td>
                                @endforeach
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-md-12" id='div_ventil' style='visibility:hidden'>
                    <div class="form-group">
                        <div class="col-md-2">
                                {!! Form::label('total_vent', 'Montant à ventiler') !!}
                                {!! Form::text('total_vent', null, ['id'=>'total_vent',
                                            'class' => 'form-control',
                                            'placeholder'=>'Total à ventiler',
                                            'onchange'=>'set_vent()']) !!}

                                {!! Form::text('total_a_vent', null, ['id'=>'total_a_vent',
                                            'class' => 'form-control',
                                            'readonly', 'style'=>'color:grey;font-style:italic;']) !!}
                        </div>
                    </div>
                    <table class="table table-striped table-condensed table-bordered">
                        <theader>
                            <tr>
                                <th ></th>
                                @foreach($tmois as $mois=>$libelle)
                                    <td width='100px'>{!! Form::label($mois, $libelle) !!}</td>
                                @endforeach
                            </tr>
                        </theader>
                        <tbody>
                            <tr>
                                <th>Ventilation<small style='font-weight:normal'><br>Ajouté au salire</small></th>
                                @foreach($tmois as $mois=>$libelle)
                                    <td>

                                    <input class='ventil checkbox' type='checkbox' 
                                        value='0' 
                                        id='{!! $mois !!}_check' 
                                        onchange='set_vent()'
                                        style='visibility:hidden'/>

                                        {!! Form::text($mois.'_vent', null, 
                                            ['id'=>$mois.'_vent','class' => 'form-control','onchange'=>'calc_vent()']) !!}
                                    </td>

                                @endforeach
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-md-12" id='div_modif' style='visibility:hidden'>
                    <div class="form-group">
                        <div class="col-md-2">
                            Modifications
                        </div>
                    </div> 
                </div>    


            </div>
        {!! Form::close() !!}
    </div>
@endsection

@section('scripts')
    {!! Html::script('js/jquery.fancybox.js') !!}
    <script type="text/javascript">
        $(document).ready(function() {
            $(".box_log").fancybox({
                width:'550px',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {
                    
                },
                afterClose: function () {
                    return;
                }
            })
        });

        function ventiler() {
            if($('#ventil_active').val()==0) {
                $('#div_ventil').attr('style','visibility:show');
                $('.ventil').attr('style','visibility:show');
                $('#ventil_active').val(1);
            } else {
                $('#div_ventil').attr('style','visibility:hidden');
                $('.ventil').attr('style','visibility:hidden');
                $('#ventil_active').val(0);
                raz_vent();
            }
        }
        function set_vent() {
            var total=$('#total_vent').val();
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            var nb=0;
            //Compte le nomnbre de mois
            for(var i=0;i<t_mois.length;i++) {
                if($('#'+t_mois[i]+'_check').prop( "checked" )) {
                    nb++;
                }
            }
            var ventmois=0;
            var reste=0;
            if(nb>0) {
                ventmois=parseInt(total/nb);
                if(nb*ventmois!=total) reste=total-nb*ventmois;
            }
            for(var i=0;i<t_mois.length;i++) {
                if($('#'+t_mois[i]+'_check').prop( "checked" )) {
                    if(i==(t_mois.length-1)) ventmois+=reste;
                    $('#'+t_mois[i]+'_vent').val(ventmois);

                } else {
                     $('#'+t_mois[i]+'_vent').val(0);
                }
            }
            calc_vent();
        }
        function raz_vent() {
            $('#total_vent').val(0);
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            for(var i=0;i<t_mois.length;i++) {
                     $('#'+t_mois[i]+'_vent').val(0);
            }
            calc_vent();
        }
        function calc_vent() {
            var total=$('#total_vent').val();
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            var total_vent=0;

            for(var i=0;i<t_mois.length;i++) {
                total_vent+=parseInt($('#'+t_mois[i]+'_vent').val());
            }
            $('#total_a_vent').val(total_vent);
            var reste = parseInt($('#total_vent').val())-parseInt($('#total_a_vent').val());
            if(reste>0) $('#total_a_vent').val(total_vent+" ("+reste+")");
        }
    </script>
@endsection
