@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/jquery.fancybox.css') !!} 
{!! Html::style('css/jquery.fancybox-buttons.css') !!} 

@php
$t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
            5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
@endphp

<div style="background-color:rgba(30,144,255,.2);"  class="col-lg-max container-fluid">
    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/salaire.png", 
                    "Salaires", 
                    array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                !!} 
            </div>
            <div class="col-xs-10" style="padding-left:0px;">
                <h1 style="margin-top:2px;margin-bottom:0px">
                    Salaires
                </h1>
                <h1 style="margin-top:0px;"><small>{!! substr($employeur_nom,strpos($employeur_nom,' ')) !!}</small><h1>
            </div>
        </div>
    </div>

    <div class='form-group ' style="padding-bottom:20px">
        <div class="col-xs-4">    
            {!! Form::hidden('employeur_id2', $employeur_id, ['id'  => 'employeur_id2']) !!}
            {!! Form::label('employeur_nom', 'Employeur :' ) !!}
            {!! Form::text('employeur_nom', $employeur_nom, 
                ['placeholder' => 'Employeur', 'class' => 'form-control'
                    , 'id' => 'employeur_nom']) !!}
 
            <!-- source: "../autocomplete_employeur", -->
            <script>
                $(function() {        
                   $("#employeur_nom").autocomplete({
                        source: "{!! route('autocomplete_employeur') !!}",
                        minLength: 1,
                        select: function(event, ui) {
                            var uid_=ui.item.id;
                            var value_=ui.item.value
                            if(value_=='TOUS') uid_="999999";
                            $('#employeur_nom').val(uid_+" "+(value_.trim()));
                            $('#employeur_id2').val(uid_);
                            location.href="{!! url('/recouvrement/salaire_annee/') !!}/"
                                +$('#employeur_id2').val()+"/0"+"/0";
                        },
                        close: function(event, ui) {
                            
                        }
                    }); 

                });
            </script>
        </div>
        <div class="col-xs-2">
            {!! Form::label('annes', 'Année :' ) !!}
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('/recouvrement/salaire_annee/') !!}/"
                            +$('#employeur_id2').val()+"/"+$('#beneficiaire_id2').val()+"/"+$('#exercice_id').val();
                    });
                });
            </script>
        </div>
        @if($employeur_id!="")
        <div class="col-xs-4">
            {!! Form::label('employe_nom', 'Employé :', []) !!}
            {!! Form::select('beneficiaire_id',$liste_employes,$beneficiaire_id,
                [
                    'id' => 'beneficiaire_id2','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#beneficiaire_id2').on('change', function() {
                        location.href="{!! url('/recouvrement/salaire_annee/') !!}/"
                            +$('#employeur_id2').val()+"/"+$('#beneficiaire_id2').val()+"/"+$('#exercice_id').val();;
                    });
                });
            </script>
        </div>
        @endif
        <a title="Historique des modifications" style='margin-top:22px'
            href="{!! url('log_salaires/'.$exercice.'/'.$employeur_id) !!} " 
            class="btn bt-sm btn-default box_log fancybox.iframe">Journal des modifications</a>

    </div>
    <br/><br/>
    @if($employeur_id!="")
        <div class="table-responsive">
            <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th >Employé</th>
                        <th width='1%'>DateNais.</th>
                        <th width='1%'>Année</th>
                        <th width='1%'>DateEnt.</th>
                        <th width='1%'>DateSor</th>
                        @if($employeur_nom=="TOUS")
                            <th >N°Emp.</th>
                            <th >Employeur</th>
                        @endif
                        
                        @foreach($t_mois as $mois)
                        <th class="sum" width='5%'>{!! $mois !!}</th>
                        @endforeach
                        <th width='5%'>Total</th>
                        <th width='5%'>Der.Modif.</th>
                        <th width='1px'></th>
                    </tr>
                </thead>
                <tfoot>
                    <tr class='bg-danger'>
                        <th colspan="{!! ($employeur_nom=='TOUS')?'8':'6' !!}">TOTAL</th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                        <th class="sum"></th>
                    </tr>
                </tfoot>
                <tfoot>
                    <tr class='bg-info'>
                        <td colspan="{!! ($employeur_nom=='TOUS')?'8':'6' !!}"></td>
                        @foreach($nb_salaire as $mois=>$nb) 
                            <td align="center" style="{!! ($mois=='total')?'font-weight:bold':'' !!}">{!! $nb !!}</td>
                        @endforeach
                        <td class=""></td>
                        <td class=""></td>
                    </tr>
                </tfoot>

                <tbody>

                    @foreach ($salaires as $salaire)
                        @php
                            $color_histo="default";$lib_update="Modifié il y a plus de 3 mois";
                            $diff=App\Models\MyApp::getNbjDate($salaire->updated_at,date('Y-m-d'));
                            if($diff<90) {$color_histo="info";$lib_update='Modifié dans les 3 mois';}
                            if($diff<60) {$color_histo="warning";$lib_update='Modifié dans les 2 mois';}
                            if($diff<30) {$color_histo="danger";$lib_update='Modifié dans le mois';}
                        @endphp
                        <tr>
                            <td>{!! $salaire->benum !!}</td>
                            <td>
                                <a href="{!! url('tiers/beneficiaires/'.$salaire->benum) !!}" target='_blank'>
                                    {!! $salaire->beneficiaire_Nom !!}
                                </a>
                            </td>
                            <td nowrap>{!! $salaire->BeneficiaireDateNaissance !!}</td>
                            <td nowrap align='center'>{!! $salaire->annee !!}</td>
                            <td nowrap>{!! $salaire->dat_ent !!}</td>
                            <td nowrap>{!! $salaire->date_sor !!}</td>
                            @if($employeur_nom=="TOUS")
                                <td nowrap>{!! str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT) !!}</td>
                                <td>{!! $salaire->employeur_nom !!}</td>
                            @endif

                            @foreach($t_mois as $mois)
                                @php
                                    $horsplafond=$salaire->getIsHorsPlafond($mois);
                                    $montant_salaire=$salaire->{$mois};
                                    $style="";
                                    if($horsplafond) $style.="color:red;";
                                    if($salaire->getSuspendu($mois)) {
                                        $style.="background-color:darkgrey;font-size:.9em";
                                        $montant_salaire="SUSPENDU";
                                    }
                                @endphp
                                <td nowrap align='right' style='{!! $style !!}'>
                                    {!! $montant_salaire !!}
                                </td>
                            @endforeach
                            <td nowrap align='right'>{!! $salaire->TotalAnnee !!}</td>
                            <td nowrap align='right'>
                                <a title="{!! $lib_update !!}" href="{!! url('log_salaires/'.$salaire->id) !!} " 
                                    class="btn bt-sm btn-{!! $color_histo !!} box_log fancybox.iframe">
                                {!! $salaire->updated_at !!}</a>
                            </td>
                            <td nowrap>
                            @if($user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('recouvrement/salaires/'.$salaire->id .'/edit') !!}"
                                    class="btn btn-info glyphicon glyphicon-pencil"></a>
                            @endif 
                            @if($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('recouvrement/salaires/create/'.$salaire->benum.'/'.$employeur_id) !!}"
                                    class="btn btn-success glyphicon glyphicon-plus"
                                    ></a>
                            @endif 
                            @if( 
                                ($user->can("SAL_SUP") || $user->HasRole("ADMINISTRATEUR")) &&  
                                    ( ($salaire->annee>date('Y')) 
                                        || ($salaire->annee<'1980') 
                                        ||($salaire->TotalAnnee==0))

                                    )
                                {!! Form::open(['url' => '/recouvrement/salaires/' . $salaire->id.'/'.$employeur_id.'/'.$beneficiaire_id.'/'.$exercice, 'method' => 'DELETE']) !!}
                                {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                                {!! Form::close() !!}
                            @endif 
                            </td>
                        </tr>
                    @endforeach


                </tbody>
            </table>
        </div>
        <div class="col-lg-10" style="margin-bottom:10px"> 
            @if($beneficiaire_id>0)       
            <div>  
                @if($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR"))
                     <a href="{!! url('recouvrement/salaires/create/'.$beneficiaire_id.'/'.$employeur_id) !!}" 
                            class="btn btn-success">Ajouter un Salaire</a> 
                @endif
                <a href="{!! url('/attestation_edition/'.$beneficiaire_id.'/E/att_revenu') !!}" 
                    class="btn btn-info" target="_blank">Attestation de déclaration</a>
                        
                @if($user->can("SAL_EDIT") || $user->HasRole("ADMINISTRATEUR"))
                    <a href="{!! url('/salaire/liquidation/'.$beneficiaire_id) !!}" 
                        class="btn btn-info" target="_blank">Edition des liquidations</a>

                    <a href="{!! url('/salaire/liquidation_simulation/'.$beneficiaire_id) !!}" 
                        class="btn btn-warning" target="_blank">Edition d'une Simulation de liquidation</a>
                @endif
             </div> 
            @endif
        </div> 
    @endif
</div>

</body>
</html>



{!! Html::script('js/jquery.fancybox.js') !!}
<script>
$(document).ready(function() {
    
    $(".box_log").fancybox({
        width:'80%',
        autoDimensions:false,
        fitToView   : false,
        autoSize    : false,
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
        afterLoad: function () {
            
        },
        afterClose: function () {
            return;
        }
    })

   $.fn.dataTable.moment('D/M/YYYY');
    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: true,
        bFilter: true,
                scrollY:        400,
                scrollX:        '100%',
                scrollCollapse: true,
                scroller:       true,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
            },
            dom: "<'row'<'col-sm-3 text-left'f><'col-sm-4'><'col-sm-5 text-center'B>>" +
            "<'row'<'col-sm-12'tir>>" +
            "<'row'<'col-sm-5'><'col-sm-7'p>>",
            "aaSorting": [[1,'asc']],
            buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    {extend: 'pdf',orientation: 'landscape',pageSize: 'A3',exportOptions: {columns: ':visible'} },
                    {extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],
            "footerCallback": function(row, data, start, end, display) {
              var api = this.api();
                @if($employeur_nom=="TOUS")
                api.columns([8,9,10,11,12,13,14,15,16,17,18,19,20], { //
                @else
                api.columns([6,7,8,9,10,11,12,13,14,15,16,17,18], { //
                @endif
                page: 'current'
                }).every(function() {
                    var sum = this
                      .data()
                      .reduce(function(a, b) {
                        var x = parseFloat(a) || 0;
                        var y = parseFloat(b) || 0;
                        return x + y;
                      }, 0);
                    $(this.footer()).html(sum);
                  });
                },
            });

        $('#_table').DataTable().draw();

        $(window).resize(function () {
                    $('#_table').DataTable().draw();
        });
    } );
</script>

