@include('forms.fbncheader_nomenu')
@include('forms.fdatatables')


<div style="background-color:rgba(30,144,255,.2);"  
    class="col-lg-max container-fluid">


        <div class="table-responsive">
            <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th >Employé</th>
                        <th width='1%'>DateNais.</th>
                        <th width='1%'>Année</th>
                        <th width='1%'>DateEnt.</th>
                        <th width='1%'>DateSor</th>
                        <th >N°Emp.</th>
                        <th >Employeur</th>
                        <th >Statut Emp.</th>
                        <th class="sum" width='5%'>Jan</th>
                        <th width='5%'>Fév</th>
                        <th width='5%'>Mar</th>
                        <th width='5%'>Avr</th>
                        <th width='5%'>Mai</th>
                        <th width='5%'>Jui</th>
                        <th width='5%'>Jui</th>
                        <th width='5%'>Aou</th>
                        <th width='5%'>Sep</th>
                        <th width='5%'>Oct</th>
                        <th width='5%'>Nov</th>
                        <th width='5%'>Déc</th>
                        <th width='5%'>Total</th>
                    </tr>
                </thead>


                <tbody>
                    @foreach ($salaires as $salaire)
                    <tr>
                        <td>{!! $salaire->benum !!}</td>
                        <td>{!! $salaire->beneficiaire_Nom !!}</td>
                        <td nowrap>{!! $salaire->BeneficiaireDateNaissance !!}</td>
                        <td nowrap align='center'>{!! $salaire->annee !!}</td>
                        <td nowrap>{!! $salaire->dat_ent !!}</td>
                        <td nowrap>{!! $salaire->date_sor !!}</td>
                        <td nowrap>{!! str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT) !!}</td>
                        <td>{!! $salaire->EmployeurNom !!}</td>
                        <td>{!! $salaire->EmployeurStatut !!}</td>
                        <td nowrap align='right'>{!! $salaire->jan !!}</td>
                        <td nowrap align='right'>{!! $salaire->fev !!}</td>
                        <td nowrap align='right'>{!! $salaire->mar !!}</td>
                        <td nowrap align='right'>{!! $salaire->avr !!}</td>
                        <td nowrap align='right'>{!! $salaire->mai !!}</td>
                        <td nowrap align='right'>{!! $salaire->jun !!}</td>
                        <td nowrap align='right'>{!! $salaire->jui !!}</td>
                        <td nowrap align='right'>{!! $salaire->aou !!}</td>
                        <td nowrap align='right'>{!! $salaire->sep !!}</td>
                        <td nowrap align='right'>{!! $salaire->oct !!}</td>
                        <td nowrap align='right'>{!! $salaire->nov !!}</td>
                        <td nowrap align='right'>{!! $salaire->dec !!}</td>
                        <td nowrap align='right'>{!! $salaire->TotalAnnee !!}</td>
                    </tr>
                    @endforeach


                </tbody>
     
            </table>

        </div>

</div>

</body></html>


<script>
$(document).ready(function() {
   $.fn.dataTable.moment('D/M/YYYY');

    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: false,
        bInfo: true,
        bFilter: true,
                scrollY:        400,
                scrollX:        '100%',
                scrollCollapse: true,
                scroller:       true,

        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

            },

            //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
            dom: "<'row'<'col-sm-3 text-left'f><'col-sm-4'><'col-sm-5 text-center'B>>" +
            "<'row'<'col-sm-12'tir>>" +
            "<'row'<'col-sm-5'><'col-sm-7'p>>",

            "aaSorting": [
                [1,'asc']
            ],

            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                //{extend: 'pdf',orientation: 'landscape',pageSize: 'A3',exportOptions: {columns: ':visible'} },
                //{extend: 'print',exportOptions: {columns: ':visible'} },
                //'colvis'
            ],
            
        } );

        $('#_table').DataTable().draw();

        $(window).resize(function () {
                    $('#_table').DataTable().draw();
        });
} );
</script>

