@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/jquery-ui.structure.min.css') !!}
{!! Html::style('css/jquery-ui.theme.min.css') !!}

<div style="background-color:rgba(34,119,34,.2);"  
    class="col-lg-max col-lg-offset-1 container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/entreprise_email.png", 
                    "Employeurs", array( 'width'=>'100%',"style"=>"padding:4px" ))
                !!} 
            </div>
            <div class="col-xs-10" style="padding-left:0px;">
                <h1 style="margin-top:2px;">
                    Employeurs Actifs<small> - Email envoyés</small>
                </h1>
            </div>
        </div>
    </div>

    <div class='col-lg-max' style="padding-top:5px">
        <div class="table-responsive" >
            <table id="_table" style="background-color:white"  
                class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th>Nom</th>
                        <th width='1px'>ile</th>
                        <th width='30%'>Responsable</th>
                        <th width='1px'>DernierEmail</th>
                        <th width='1px'>Trimestre&nbsp;du dernier&nbsp;envoi</th>
                        <th width='1px'>Nb Emails</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'></th>
                    </tr>
                </thead>
     
                <tbody>

                    @foreach ($employeurs as $employeur)
                    <?php
                        $date=$employeur->getSendEmailLastDate("REC_BRD_RELEVE");
                    ?>
                    <tr class="clickable-row" data-href="./employeurs/{!! $employeur->id !!}">
                        <td>
                            {!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}
                        </td>
                        <td nowrap>{!! $employeur->NomReduit !!}<br/>{!! $employeur->email !!}</td>
                        <td align='center'>{!! $employeur->ile !!}</td>
                        <td>{!! (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable !!}</td>
                        <td nowrap>{!! $date !!}</td>
                        <td nowrap align='center'>{!! $employeur->getEmailTrim('REC_BRD_RELEVE') !!}</td>
                        <td nowrap align='center'>{!! $employeur->NbSendEmail !!}</td>
                        <td align='center'>{!! $employeur->statut !!}</td>
                        <td nowrap>
                            <a href="{!! url('recouvrement_showmails').'/'.$employeur->id !!}" 
                                class="box_emails fancybox.iframe btn btn-info" 
                                style="margin-right: 3px;">Voir les Emails</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

</div>



</body></html>

@include('forms.fdatatables_script')

<script>

    $(".box_emails").fancybox({
        fitToView   : true,
        width       : '65%',
        height      : '60%',
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
    });
</script>

