@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/jquery-ui.structure.min.css') !!}
{!! Html::style('css/jquery-ui.theme.min.css') !!}

{!! Html::script('js/bootstrap-datepicker.js') !!} 

<div style="background-color:rgba(255,182,193,.2);"  
    class="col-lg-max col-lg-offset-1 container-fluid">

<div style="padding-left:0px" class="col-lg-max">
    <div class="row" style="">   
        <div class="col-xs-1" style="padding-left:0px;">
           {!! Html::image("img/entreprise_med.png", 
                "Employeurs", 
                array( 'width'=>'100%',
                    "style"=>"padding:4px" ))
            !!} 
        </div>
        <div class="col-xs-10" style="padding-left:0px;">
            <h1 style="margin-top:2px;">
                 Reste à payer par année de rattachement<small> - Employeurs Actifs et non actifs</small>
            </h1>
        </div>    
    </div>

    <div class="row"  style="padding-left:20px;margin-bottom:30px">   
        <div class='col-md-2' >
            {!! Form::label('exercice', 'Exercice&nbsp;') !!}
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control ',
                    'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
        </div>
        <div class='col-md-2' >
            {!! Form::label('date_obs', 'Date d\'observation') !!}
            <div class='input-group date' id='datepicker_date_obs'>
                {!! Form::text('date_obs', $date_obs_fr, [
                    'placeholder' => 'Date', 
                    'class' => 'form-control'
                ]) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
        <div class='col-md-2' >
                <a href="#" class="btn btn-default pull-left" 
                    onclick="javascript:valide_date();" style="margin-top:25px;margin-right: 3px;">
                    OK
                </a>
        </div>

    </div>
</div>  

<div class='col-lg-max' style="padding-top:5px">
    <div class="table-responsive" >
        <table id="_table" style="background-color:white"  
            class="table table-condensed table-striped table-hover table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th width='10%'>Nom</th>
                    <th width='1%'>Statut</th>
                    <th width='1%'>Reste&nbsp;a&nbsp;payer<br>sur&nbsp;Exercice<br>{!! $exercice !!}</th>
                    <th width='1%'>Reste&nbsp;a&nbsp;payer<br>au<br>{!! $date_obs_fr !!}</th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($employeurs as $employeur)
                <?php
                    $rap_an=$employeur->getResteAPayerExercice($exercice,$date_obs);
                    $rap_date=$employeur->getResteAPayerCumule($exercice,$date_obs);

                    $style_rap_an=($rap_an<0)?"color:red":"color:green";
                    $style_rap_date=($rap_date<0)?"color:red":"color:green";

                ?>
                    <tr>
                        <td>
                            {!! str_pad($employeur->id,4,'0',STR_PAD_LEFT) !!}
                        </td>
                        <td nowrap>
                            <a href="{!! url('tiers/employeurs/')."/".$employeur->id !!}" target="_blank">
                                {!! $employeur->NomReduit !!}
                            </a>
                        </td>
                        <td align="right" nowrap>{!! $employeur->statut !!}</td>
                        <td align="right" style="{!! $style_rap_an !!}">
                        <a href="{!! url('recouvrement/cotisations_employeur_exercice/'.$employeur->id.'/'.$exercice.'/'.$date_obs) !!}" 
                                        id='btn_ajout_imputation' 
                                        class="box_detail fancybox.iframe" 
                                        target="_blank">{!! $rap_an !!}</a>
                        </td>
                        <td align="right" style="{!! $style_rap_date !!}">
                            <a href="{!! url('recouvrement/cotisations_employeur_cumule/'.$employeur->id.'/'.$exercice.'/'.$date_obs) !!}" 
                                id='btn_ajout_imputation' 
                                class="box_detail fancybox.iframe" 
                                target="_blank">{!! $rap_date !!}</a>
                        </td>

                    </tr>
               
                @endforeach
            </tbody>
        </table>
    </div>
</div>

</div>




</body></html>

<script>

        $(".box_detail").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {

            },
            afterClose: function () {

                return;
            }
        });

        $('#exercice_id').on('change', function() {
            //valide_date();
            $('#date_obs').val("");
        });
        $('#datepicker_date_obs').datepicker({
            format: "dd/mm/yyyy",
            language: "fr",
            autoclose: true
        });

        function valide_date() {
            var date =$('#date_obs').val();
            var elem = date.split('/');
            jour = elem[0];mois=elem[1];annee=elem[2];
            date=  annee+"-"+mois+"-"+jour; 
            if(date=="") {
                alert("Il faut saisir une date valide");
                return;
            }
            date=date.replace(/\//g, "-");
            location.href="{!! url('/recouvrement/reste_a_payer_annee/') !!}"
                +"/"+$('#exercice_id').val()
                +"/"+date;
        };


    $(document).ready(function() {
        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            //deferRender:    true,
            scrollY:        "400px",
            scrollX:        true,
            scrollCollapse: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },

                "aaSorting": [
                    [0,'desc']
                ],

                "aoColumnDefs": [
                    { "sTypes": "numeric", "aTargets": [ 3,4 ] },
                    { bSortable: false, aTargets: [] },
                    { visible: false, targets: [] },
                ],


                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    {extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],

            } );

        $('#_table').DataTable().draw();

        //$(window).resize(function () {
        //    $('#_table').DataTable().draw();
        //});

    } );
</script>



