@include('forms.fbncheader')
@include('forms.fdatatables')

<div class='col-lg-max col-lg-offset-1'>

    <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
        <div class="row">
            <div class="col-xs-max">
                <h4>Situation au 31/12/{!! $exercice !!}</h4>
            </div>
            <div class="col-xs-2">
                {!! Form::label('exercice', 'Année :' ) !!}
                {!! Form::select('exercice',$exercices,$exercice,
                    [
                        'id' => 'exercice_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",
                        'style' => 'font-weight:bold;background:whitesmoke'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#exercice_id').on('change', function() {
                            location.href="{!! url('/stats/optimind') !!}/"
                                +$('#exercice_id').val();
                        });
                    });
                </script>
            </div>
        </div>
</div>

<br/>
<div class='col-xs-11 col-xs-offset-1'>

        <div class="row">
            <div class="table-responsive">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Nom</th>
                            <th>Genre</th>
                            <th>Date de naissance</th>
                            <th>Date<br>immatriculation</th>
                            <th>Date Premier<br>salaire</th>
                            <th>Secteur</th>
                            <th>Nb mois<br>déclarés</th> 
                            <!-- <th>Droit acquis</th>-->
                            <th>Salaire moyen des 15 meilleurs années</th>
                            <th>Situation familiale actuelle</th>
                            <th>Nombre d'enfants au {!! "31/12/".$exercice !!}</th>
                            <th>Rémunération {!! $exercice !!} </th>
                            <th>Date de départ à la retraite </th>
                            <th>Rente </th>
                            <th>Réservataire</th>
                            <th>Statut</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                            //statuts retraités autorisés
                            $t_statuts=['R','RA','RAU','RAV','RVE','AR','SAR','AAV']; 
                        ?>
                        @foreach($beneficiaires as $beneficiaire)
                        <?php
                            $secteur="";
                            $is_retraite=false;
                            $infosalaire=$beneficiaire->getOPTI_InfoSalairesAttribute($exercice);
                            $t=explode('~',$infosalaire);
                            $masse=$t[1];//;$beneficiaire->getMasseSalariale($exercice);
                            $nb_mois=$t[0];//$beneficiaire->getNbMoisSalairesAttribute("",$exercice);
                            $salaire_moyen_best=$t[2];//$beneficiaire->getSalaireMoyenMeilleursAnneesAttribute($exercice);
                            
                            $date_premier_salaire=$beneficiaire->getDatePremierSalaireImmatAttribute();
                            $secteur=$beneficiaire->getSecteurLastSalaire($exercice);
                            if($nb_mois==0) {
                                /*if($beneficiaire->id=="9014") 
                                    dd($beneficiaire->statut." => ".(false !== array_search($beneficiaire->statut, $t_statuts)));
                                */
                                if(false !== array_search($beneficiaire->statut, $t_statuts)) {
                                    $is_retraite=true;
                                    
                                }
                            }
                        ?>
                        @if(($nb_mois!=0)||($is_retraite))
                        <tr>
                            <td>{!! $beneficiaire->id !!}</td>
                            <td>
                                <a href="{!! url('tiers/beneficiaires_statut/'.$beneficiaire->id.'/RET') !!}" target="_blank">
                                    {!! $beneficiaire->nom_complet !!}
                                </a> 
                            </td>
                            <td>{!! $beneficiaire->civilite !!}</td>
                            <td align="center">{!! $beneficiaire->datenaiss !!}</td>
                            <td align="center">{!! $beneficiaire->date_pi !!}</td>
                            <td align="center">{!! $beneficiaire->DatePremierSalaire !!}</td>
                            <td>{!! $secteur !!}</td>
                            <td align="right">{!! $nb_mois !!}</td>
                            <td align="right">{!! $salaire_moyen_best !!}</td>
                            <!-- <td align="right">{!! $beneficiaire->droitsacquis !!}</td> -->
                            
                            <td>{!! (($beneficiaire->conjoint>0)?"AVEC CONJOINT":"SANS CONJOINT") !!}</td>
                            <td align="right">{!! $beneficiaire->getNbEnfants($exercice."-12-31") !!}</td>
                            <td>{!! $masse !!}</td>
                            <td align="center">{!! $beneficiaire->ret_dateed  !!}</td>
                            <td align="right">{!! $beneficiaire->ret_montant  !!}</td>
                            <td>{!! (($beneficiaire->ret_type=="PRV")||($beneficiaire->ret_type=="PRA"))?"O":"N" !!}</td>
                            <td>{!! $beneficiaire->statut !!}</td>
                        </tr>
                        @endif
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>  
    </div>  



<script>


    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: true,
        bInfo: true,
        bFilter: true,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,
        iDisplayLength:20,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                'colvis'
            ],
            
            columnDefs: [ {
                        targets: ['_all'],
                        visible: true
                    } ]
 


        } );



</script>
