@include('forms.fbncheader')
@include('forms.fdatatables')

<div class='col-lg-max col-lg-offset-1'>

    <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
        <div class="row">
            <div class="col-xs-max">
                <h4>Nombre d'employés au {!! $exercice !!}</h4>
            </div>
            <div class="col-xs-2">
                {!! Form::label('exercice', 'Année :' ) !!}
                {!! Form::select('exercice',$exercices,$exercice,
                    [
                        'id' => 'exercice_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",
                        'style' => 'font-weight:bold;background:whitesmoke'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#exercice_id').on('change', function() {
                            location.href="{!! url('/stats/salaires') !!}/"
                                +$('#exercice_id').val()+"/"+$('#mois_id').val();
                        });
                    });
                </script>
            </div>
            <div class="col-xs-2">
                {!! Form::label('mois', 'Mois :' ) !!}
                {!! Form::select('exercice',$t_mois,$mois,
                    [
                        'id' => 'mois_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",
                        'style' => 'font-weight:bold;background:whitesmoke'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#mois_id').on('change', function() {
                            location.href="{!! url('/stats/salaires') !!}/"
                                +$('#exercice_id').val()+"/"+$('#mois_id').val();
                        });
                    });
                </script>
            </div>
        </div>


</div>

<br/>
<div class='col-xs-11 col-xs-offset-1'>

        <div class="row">
            <div class="table-responsive">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%">
                    <thead>
                        <tr>
                            <th width="20%" style="vertical-align:middle" rowspan="2">Id</th>
                            <th width="20%" style="vertical-align:middle" rowspan="2">Employeur</th>
                            <th width="1%" style="vertical-align:middle" rowspan="2">Secteur</th>
                            <th width="1%" style="vertical-align:middle" rowspan="2">District</th>
                            @for($i=$deb_mois;$i<=$fin_mois;$i++)
                                <th width="1%" style="text-align:center" colspan="2" >{!! $t_mois[$i] !!}</th>
                            @endfor
                        </tr>
                        <tr>
                            @for($i=$deb_mois;$i<=$fin_mois;$i++)
                                <th width="1%" style="background-color:#A6BFE9;" align="right">NbSal</th>
                                <th width="1%" style="background-color:#B9F2CE;">MasseSal.</th>
                            @endfor
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($societes as $societe)
                        <tr>
                            <td>{!!  str_pad($societe->ref,4,'0',STR_PAD_LEFT) !!}</td>
                            <td>
                                @if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="./employeurs/{!! $societe->ref !!}" 
                                        class="" style="margin-right: 3px;" target="_blank">
                                @endif

                                {!! (strlen($societe->nom)>30)?substr($societe->nom,0,40)."...":$societe->nom !!}

                                @if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    </a>
                                @endif 
                            </td>
                            <td>{!! $societe->Secteur !!}</td>
                            <td>{!! $societe->district !!}</td>
                            @for($i=$deb_mois;$i<=$fin_mois;$i++)
                                <td style="background-color:#A6BFE9;"  align="right">{!! (!isset($t_employeurs["nbsal"][$i][$societe->ref]))?"":$t_employeurs["nbsal"][$i][$societe->ref] !!}</td>
                                <td style="background-color:#B9F2CE;" align="right">{!! (!isset($t_employeurs["massesal"][$i][$societe->ref]))?"":$t_employeurs["massesal"][$i][$societe->ref] !!}</td>
                            @endfor
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>  
    </div>  



<script>


    var table =$('#_table').dataTable( {
        bAutoWidth: false,
        bPaginate: true,
        bInfo: false,
        bFilter: false,
        deferRender:    true,
        scrollCollapse: false,
        scroller:       false,
        iDisplayLength:20,
        oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher ",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',
                print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                }
            }

            },
            dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [ 
                {extend: 'copy',exportOptions: {columns: ':visible'} },
                {extend: 'excel',exportOptions: {columns: ':visible'} },
                {extend: 'pdf',exportOptions: {columns: ':visible'} },
                {extend: 'print',exportOptions: {columns: ':visible'} },
                'colvis'
            ],
            
            columnDefs: [ {
                        targets: ['_all'],
                        visible: true
                    } ]
 


        } );



</script>
