@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">
    <h1><i class="fa fa-secteurs"></i>Secteurs</h1>


    <div class="row" style="margin-bottom:40px">   
            <div class="col-xs-3">
                {!! Form::label('annes', 'Année :' ) !!}
                {!! Form::select('exercice',$exercices,$exercice,
                    [
                        'id' => 'exercice_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",'style' => 'font-weight:bold;'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#exercice_id').on('change', function() {
                            location.href="{!! url('/stats/secteur_general/') !!}/"
                                +$('#exercice_id').val()+"-"+$('#mois_id').val()+"-01";
                        });
                    });
                </script>
            </div>
            <div class="col-xs-2">
                {!! Form::label('mois', 'Mois :' ) !!}
                {!! Form::select('mois',$moiss,$mois,
                    [
                        'id' => 'mois_id','class' => 'form-control selectpicker',
                        'data-width' => "100%",'style' => 'font-weight:bold;'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#mois_id').on('change', function() {
                            location.href="{!! url('/stats/secteur_general/') !!}/"
                                +$('#exercice_id').val()+"-"+$('#mois_id').val()+"-01";
                        });
                    });
                </script>
            </div>
    </div>

    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered table-bordered">
            <thead>
                <tr>
                    <th width='1%'>Id</th>
                    <th>Nom</th>
                    <th style='text-align:center'>Nb employeurs</th>
                    <th style='text-align:center'>Nb employés</th>
                    <th style='text-align:center'>Masse salariale</th>
                </tr>
            </thead>
 
            <tbody>
                <?php
                    $total_employeurs=0;
                    $total_employes=0;
                    $total_masse_salariale=0;
                ?>
                @foreach ($secteurs as $secteur)
                    <?php
                        $nb_employeurs=$secteur->getNbEmployeurs($date);
                        $nb_employes=$secteur->getNbEmployes($date);
                        $masse_salariale=$secteur->getMasseSalariale($date);
                        $total_employeurs+=$nb_employeurs;
                        $total_employes+=$nb_employes;
                        $total_masse_salariale+=$masse_salariale;
                    ?>
                    <tr>


                        <td>{!! $secteur->id !!}</td>
                        <td nowrap >
                            <a href="{!! url('salaire_secteurs_iframe/'.$secteur->id.'/'.$exercice.'-'.$mois.'01') !!}" class="box_imput fancybox.iframe">
                                {{ $secteur->nom }}</a>
                        </td>
                        <td style='text-align:center'>{!! $nb_employeurs !!}</td>
                        <td style='text-align:center'>{!! $nb_employes !!}</td>
                        <td style='text-align:center'>{!! $masse_salariale !!}</td>
                    </tr>
                @endforeach
            </tbody>
 
             <tfooter>
                <tr>
                    <th width='1%'>Id</th>
                    <th style='text-align:center'>TOTAL</th>
                    <th style='text-align:center'>{!! $total_employeurs !!}</th>
                    <th style='text-align:center'>{!! $total_employes !!}</th>
                    <th style='text-align:center'>{!! $total_masse_salariale !!}</th>
                </tr>
            </tfooter>
        </table>
    </div>
</div>

</body></html>
@include('forms.fdatatables_script')

<script>

        $(".box_imput").fancybox({
            width:'90%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {
                eTarget=$(this.element).attr("id");
            },
            afterClose: function () {
                if (eTarget!="btn_visu_imputation") {
                    $("#refresh").val(true);
                    $("#form").submit();
                }
                return;
            }
        });

</script>