@include('forms.fbncheader')
@include('forms.fdatatables')




<div class="col-lg-max col-lg-offset-1 container-fluid">
    <h1><i class="fa fa-employeurs"></i>Banques</h1>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-bordered">
            <thead>
                <tr>
                    <th width='1%'>id</th>
                    <th>Nom</th>
                    <th width='1%'>Agence</th>
                    <th width='1%'>BIC</th>
                    <th width='5%'>Ville</th>
                    <th width='1%'>Tel1</th>
                    <th width='5%'>Contact1</th>
                    <th width='1%'>Tel2</th>
                    <th width='5%'>Contact2</th>
                    <th width='5%'>NbBenef</th>
                    <th width='5%'>NbEmpl.</th>
                    <th width='5%'>NbVers.</th>
                    <th width='5%'>Actif.</th>
                    <th width='185px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($banques as $banque)
                
                <tr class='{!! (($banque->active==1)?"bg-success":"bg-alert") !!}'>
                    <td style='color:grey'>{!! $banque->id !!}</td>
                    <td>{!! $banque->nom !!}</td>
                    <td nowrap>{!! $banque->agence !!}</td>
                    <td nowrap>{!! $banque->bic !!}</td>
                    <td nowrap>{!! $banque->ville !!}</td>
                    <td nowrap>{!! $banque->tel !!}</td>
                    <td nowrap>{!! $banque->contact !!}</td>
                    <td nowrap>{!! $banque->tel2 !!}</td>
                    <td nowrap>{!! $banque->contact2 !!}</td>
                    <td nowrap align="center">{!! $banque->NbBeneficiaires !!}</td>
                    <td nowrap align="center">{!! $banque->NbEmployeurs !!}</td>
                    <td nowrap align="center">{!! $banque->NbVersements !!}</td>
                    <td nowrap align="center">
                        
                        @if($banque->active==1)
                            {!! Html::image("img/check.png", "Actif", array(  'maxwidth' => '100%','width' => '20%'  )) !!}
                        @else

                        @endif
                        <span style='color:white;font-size=0px'>{!! $banque->active !!}</span>
                    <td nowrap>
                    @if($user->can("BQE_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="./banques/{!! $banque->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                    @endif 
                    @if(($user->can("BQE_SUP") || $user->HasRole("ADMINISTRATEUR"))&&($banque->actif))   
                        {!! Form::open(['url' => './tiers/banques/' . $banque->id, 'method' => 'DELETE']) !!}
                        {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                        {!! Form::close() !!}
                    @endif 
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
@if($user->can("BQE_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="./banques/create" class="btn btn-success">Ajouter une banque</a></h4>
    </div> 
@endif

</div>


</body></html>
@include('forms.fdatatables_script')