@extends('layouts.master')
 
@section('title') Nouveau beneficiaire @stop
 
@section('content')
 
<div class='col-lg-10 col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i>Nouveau bénéficiaire</h1>
 
    {!! Form::open(['beneficiaire' => 'form', 'url' => '/tiers/beneficiaires', 'class' => 'form-horizontal']) !!}

    {!! Form::hidden('type_liste',$type_liste); !!}

      <ul class="nav nav-tabs">
        <li class="active"><a href="#nom" data-toggle="tab">Etat civil-Statut</a></li>
        <li><a href="#adresse" data-toggle="tab">Adresse</a></li>
        <li><a href="#famille" data-toggle="tab">Conjoint-Famille</a></li>
        <li><a href="#banque" data-toggle="tab">Employeur/Banque</a></li>
        <li><a href="#allocation" data-toggle="tab">Allocations</a></li>
        <li><a href="#retraite" data-toggle="tab">Retraite</a></li>
    </ul>
    <script>
        $('#myTab a').click(function (e) {
            e.preventDefault();
            $(this).tab('show');
        })

        $('a[data-toggle="tab"]').on('shown', function (e) {
            e.target // activated tab
            e.relatedTarget // previous tab
        })
    </script>

<br/>

<div class="tab-content">

<!-- ------------------------------------- ONGLET NOM ------------------------------- -->
    <div class="tab-pane active" id="nom">

        <div class="form-group">
            <div class="col-md-3">
                    {!! Form::label('nom', 'Nom') !!}
                    {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
            </div>
            <div class="col-md-3">
                    {!! Form::label('prenom', 'Prénom') !!}
                    {!! Form::text('prenom', null, ['placeholder' => 'Prénom', 'class' => 'form-control']) !!}
            </div>
            <div class="col-md-3">
                {!! Form::label('civilite', 'Civilité') !!}
                <br/>
                {!! Form::select('civilite',[''=>'A définir','Mr'=>'Monsieur','Mme' => 'Madame', 'Mll' => 'Mademoiselle'],'',['class' => 'selectpicker',] ) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-3">
                {!! Form::label('datenaiss', 'Date de naissance') !!}
                    <div class='input-group date' id='datepicker_datenaiss'>
                            {!! Form::text('datenaiss', '', ['placeholder' => 'Date de naissance', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_datenaiss').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
            </div>

            <div class="col-md-4">
            {!! Form::label('lieunaiss', 'Lieu de naissance') !!}
            {!! Form::text('lieunaiss', null, ['placeholder' => 'Lieu de naissance', 'class' => 'form-control text-uppercase']) !!}
            </div>
        </div>


        <div class='form-group'>
            <div class="col-md-3">
            {!! Form::label('statut', 'Statut') !!}
            <br/>
            {!! Form::select('statut',$liste_benefstatut,'-'
                ,['class' => 'selectpicker','data-width' => "100%",'id'=>'statut']) !!}
            <script>
                $('#statut').val('-'); 
            </script>
            </div>

            <div class='col-md-2'>
                {!! Form::label('n_all', 'Certificat de vie') !!}
                {!! Form::text('n_all', null, ['placeholder' => 'Certificat de vie', 'class' => 'form-control']) !!}
            </div>

            <div class="col-md-3">
                {!! Form::label('date_pi', 'Date 1ère immatriculation') !!}
                    <div class='input-group date' id='datepicker_datepi'>
                            {!! Form::text('date_pi', '', ['placeholder' => 'Date de première immatriculation', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_datepi').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-2'>
                {!! Form::label('verrou', 'Verrou') !!}
                {!! Form::checkbox('verrou', false, ['class' => 'form-control']) !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-10">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>
    </div>

    <!-- ------------------------------------- ONGLET ADRESSE ------------------------------- -->

    <div class="tab-pane" id="adresse">


        <div class="form-group"> 
            <div class='col-md-8'>
                {!! Form::label('adresse', 'Adresse') !!}
                {!! Form::textarea('adresse', null, ['placeholder' => 'ADRESSE', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-3'>
                {!! Form::label('code_postal', 'Code postal') !!}
                {!!Form::text('code_postal', null, ['placeholder' => 'CODE POSTAL', 'class' => 'form-control']) !!}
            </div>

            <div class='col-md-3'>
                {!! Form::label('district', 'District - Zone') !!}
                <br/>
                {!! 
                Form::select(
                    'district',
                    App\Models\MyApp::DISTRICTS2,
                    '',
                    [
                        'class' => 'selectpicker','data-width' => "100%",
                    ]
                ) 
            !!}
            </div>

            <div class='col-md-3'>
                {!! Form::label('ile', 'Ile') !!}
                <br/>
                    {!! 
                    Form::select(
                        'ile',
                        App\Models\MyApp::ILES2,
                        '',
                        [
                            'class' => 'selectpicker','data-width' => "100%",
                        ]
                    )
                !!}                
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-6">
                {!! Form::label('email', 'Email') !!}
                {!! Form::email('email', null, ['placeholder' => 'EMAIL', 'class' => 'form-control'] )!!}
            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-4'>
                {!! Form::label('tel', 'Téléphone') !!}
                {!! Form::text('tel', null, ['placeholder' => 'TELEPHONE', 'class' => 'form-control']) !!}
            </div>

            <div class='col-md-4'>
                {!! Form::label('fax', 'Fax') !!}
                {!! Form::text('fax', null, ['placeholder' => 'FAX', 'class' => 'form-control']) !!}
            </div>
        </div>
        



    </div>

    <!-- ------------------------------------- ONGLET FAMILLE ------------------------------- -->

    <div class="tab-pane" id="famille">
        <div class="form-group">
            <div class="col-md-6">
                    {!! Form::label('nom_conjoint', 'Conjoint') !!}
                    {!! Form::hidden('conjoint', null, ['id' => 'conjoint']) !!}

                    <div class="input-group">
                        <span class="input-group-addon"  id='conjoint_addon'>

                        </span>
                        <input type="text" class="form-control" name="nom_conjoint" id="nom_conjoint" 
                            value='' 
                            placeholder="Conjoint" 
                            />
                    </div>
            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-2'>
                {!! Form::label('nb_enf', "Nombre d'enfants") !!}
                {!! Form::text('nb_enf', null, ['placeholder' => "Nombre d'enfants", 'class' => 'form-control']) !!}
            </div>
        </div>  

        <div class="form-group"> 
            <div class='col-md-2'>
                {!! Form::label('nb_enf_tot', "Nombre d'enfants total") !!}
                {!! Form::text('nb_enf_tot', null, ['placeholder' => "Nombre d'enfants total", 'class' => 'form-control']) !!}
            </div>
        </div>
    </div>



    <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->

    <div class="tab-pane" id="banque">



            <div class="form-group">
                <div class="col-md-6">
                    {!! Form::label('employeur', 'Employeur :' ) !!}   
                    {!! Form::hidden('sonum', null, ['id' => 'sonum']) !!}
                    <div class="input-group"  id="ref_employeur">
                        <span class="input-group-addon"  name="employeur_addon" id='employeur_addon'>  
                        </span>
                        <input type="text" class="form-control" name="employeur_nom" id="employeur_nom" 
                            value='' 
                            placeholder="Employeur" 
                            />
                    </div>
                    <script>
                        $(function() {        
                           $("#employeur_nom").autocomplete({
                                source: "{!! route('autocomplete_employeur') !!}",
                                minLength: 1,
                                select: function(event, ui) {
                                    $('#sonum').val(ui.item.id);
                                    $('#employeur_addon').html(ui.item.id);
                                },
                                change: function( event, ui ) {
                                    var id_nom=ui.item.value.trim();
                                    var nom;
                                    if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                                    $('#employeur_nom').val(nom);
                                    $('#employeur_addon').html(ui.item.id);
                                    $('#sonum').val(ui.item.id);
                                }
                            }); 
                           return;
                        });
                    </script>
                </div>
            </div>


            <div class="form-group">
                <div class="col-md-8">
                    {!! Form::label('banque_id', 'Banque') !!}
                    <br/>
                    </div>
                <div class="col-md-6">
                    {!! Form::select(
                        'banque_id',
                        array(""=>"")+DB::table('banques')->where('active','=','1')->orderby(db::raw("nom"))->pluck(db::raw("CONCAT(nom,' - ',ville)"), 'id')->toArray(),
                        '',['class' => 'selectpicker','data-width' => "100%",]) 
                    !!}
                </div>
            </div>

<!--
            <div class="form-group">
                <div class="col-md-4">
                    {!! Form::label('compte', 'Ancien Compte') !!}
                    {!! Form::text('compte', null, ['readonly' => 'true', 'class' => 'form-control'])!!}
                </div>
            </div>
-->

            <div class="form-group bg-info alert">
                <div class="col-md-12 ">
                {!! Form::label('IBAN', 'IBAN') !!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN_pays', 'Pays') !!}
                    {!! Form::text('IBAN_pays', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN', 'Clé IBAN') !!}
                    {!! Form::text('IBAN_cle', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
                <div class="col-md-2">
                    {!! Form::label('IBAN_banque', 'Banque') !!}
                    {!! Form::text('IBAN_banque', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
                <div class="col-md-2">
                    {!! Form::label('IBAN_guichet', 'Guichet') !!}
                    {!! Form::text('IBAN_guichet', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
                <div class="col-md-3">
                    {!! Form::label('IBAN_compte', 'Numéro de compte') !!}
                    {!! Form::text('IBAN_compte', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN_clerib', 'Clé RIb') !!}
                    {!! Form::text('IBAN_clerib', null, ['placeholder' => '', 'class' => 'form-control'])!!}
                </div>
            </div>

      </div>

    <!-- ------------------------------------- ONGLET ALLOCATION ------------------------------- -->

    <div class="tab-pane" id="allocation">      

        <div class="form-group">
            <div class="col-md-1">
                {!! Form::label('nb_enf', 'Nb enfants') !!}
                {!! Form::text('nb_enf', null, ['placeholder' => 'Nombre d\'enfants', 'class' => 'form-control'])!!}
            </div>
        </div>

        <br/>
        {!! Form::label('montants_allocations', 'Montants') !!}
        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-success">
                    <div class="input-group-addon" style="width:100px">Montant allocation</div>
                    {!! Form::text('mt_allloc', null, ['placeholder' => 'Montant', 'class' => 'text-right form-control'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-warning">
                    <div class="input-group-addon">Montant calculé</div>
                    {!! Form::text('mt_calc', null, ['placeholder' => 'Montant calculé', 'class' => 'text-right form-control'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-error">
                    <div class="input-group-addon ">Montant rappel</div>
                    {!! Form::text('rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <br/>
        <div class="form-group">
            <div class="col-md-8">
                {!! Form::label('obs_vers', 'Observations') !!}
                {!!  Form::textarea('obs_vers', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
         </div>

    </div>

    <!-- ------------------------------------- ONGLET RETRAITE ------------------------------- -->

    <div class="tab-pane" id="retraite">
        <div class="form-group">
            <div class='col-md-2'>
                {!! Form::label('ret_numdec', 'Numéro de décision') !!}
                {!! Form::text('ret_numdec', null, ['placeholder' => 'Numéro de décision', 'class' => 'form-control'])!!}
            </div>

            <div class="col-md-3">
                {!! Form::label('ret_dateed', 'Date de décision') !!}
                <div class='input-group date' id='datepicker_ret_dateed'>
                        {!! Form::text('ret_dateed', '', ['placeholder' => 'Date de décision', 'class' => 'form-control']) !!}
                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_ret_dateed').datepicker({
                                format: "dd/mm/yyyy",language: "fr",autoclose: true
                            });
                        });
                    </script>
                </div>
            </div>

            <div class='col-md-2'>
                {!! Form::label('ret_type', 'Type de retraite') !!}
                <br/>
                    {!! 
                    Form::select(
                        'ret_type',
                        ['' => 'A définir' , 'PRE' =>'PRE' , 'PRV' => 'PRV', 'PAV' => 'PAV', 'PRA' => 'PRA', 'AUT' => 'Autre'],
                       '',
                        [
                            'class' => 'selectpicker',
                        ]
                    )
                !!}                
            </div>
        </div>

        <br/>
        {!! Form::label('montants_retraite', 'Montants') !!}
        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-success">
                    <div class="input-group-addon ">Montant retraite</div>
                    {!! Form::text('ret_montant', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-error">
                    <div class="input-group-addon ">Montant rappel</div>
                    {!! Form::text('ret_rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control'])!!}
                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>


        <hr>
        <fieldset>
            {!! Form::label('montants_csr', 'Montants CSR') !!}
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-success">
                        <div class="input-group-addon ">Montant CSR</div>
                        {!! Form::text('csr_montant', null, ['placeholder' => 'Montant CSR', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-error">
                        <div class="input-group-addon ">Montant rappel CSR</div>
                        {!! Form::text('csr_rappel', null, ['placeholder' => 'Montant rappel CSR', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>

</div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>
 

<script type="text/javascript">
    $(function() {
        $("#nom_conjoint").autocomplete({
            source: "{!! url('auto_conjoint') !!}",
            minLength: 2,
            select: function(event, ui) {
                $('#nom_conjoint').val(ui.item.value);
                $('#conjoint').val(ui.item.id);
                $('#conjoint_addon').html(ui.item.id);
            },
            close: function(event, ui) {
                
            }
        });    
    });
</script>

@stop