@extends('layouts.master')
 
@section('title')Consultation d'un bénéficiaire @stop
 

@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
    <!-- Datatable -->
    {!! Html::style('css/dataTables.bootstrap.css'); !!} 
    {!! Html::style('css/buttons.bootstrap.css'); !!} 
@stop

@section('content')
 
<div class='col-lg-max col-lg-offset-1'  style="margin-top:-20px">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h2>Bénéficiaire <span style='color:darkred'>{!! $beneficiaire->nomcomplet !!}</span></h2>
    
    {!! Form::model($beneficiaire, ['id'=>'form','beneficiaire' => 'form'
        , 'url' => '/tiers/beneficiaires/'. $beneficiaire->id
        , 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
  
    {!! Form::hidden('type_liste',$type_liste); !!}
    {!! Form::hidden('refresh',false,['id'=>'refresh']); !!}
    {!! Form::hidden('onglet_actif','',['id'=>'onglet_actif']); !!}

    <ul class="nav nav-tabs"  id="myTab">
        <li class="active"><a href="#nom" name='nom' data-toggle="tab">Etat civil-Statut</a></li>
        <li><a href="#adresse" name='adresse' data-toggle="tab">Adresse</a></li>
        <li><a href="#famille" name='famille' data-toggle="tab">Conjoint-Famille</a></li>
        <li><a href="#banque" name='banque' data-toggle="tab">Employeur/Banque</a></li>
        <li><a href="#allocation" name='allocation' data-toggle="tab">Allocations</a></li>
        <li><a href="#salaires" name='salaires' data-toggle="tab">Salaires</a></li>
        <li><a href="#versements" name='versements' data-toggle="tab">Versements</a></li>
        <li><a href="#retraite" name='retraite' data-toggle="tab">Retraite</a></li>
    </ul>
    <script>
        $('#rowTab a:first').tab('show');
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            var nom_onglet=$(e.target).attr('name');
            $("#onglet_actif").val(nom_onglet);
        });     
    </script>


    <div class="tab-content" style="padding-top:15px">

        <!-- ------------------------------------- ONGLET NOM ------------------------------- -->
        <div class="tab-pane active" id="nom">
            <div class="form-group">
                <div class="col-md-2">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='{!! str_pad($beneficiaire->id, 6, "0", STR_PAD_LEFT) !!}' />
                    </div>
               </div>
               </div>
            </div>

            <div class="col-md-9 bg-success">
                <div class="form-group">
                    <div class="col-md-3">
                            {!! Form::label('nom', 'Nom') !!}
                            {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
                    </div>
                    <div class="col-md-3">
                            {!! Form::label('prenom', 'Prenom') !!}
                            {!! Form::text('prenom', null, ['placeholder' => 'Prénom', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-md-3">
                    {!! Form::label('civilite', 'Civilité') !!}
                    <br/>
                    {!! Form::select('civilite',[''=>'A définir','Mr'=>'Monsieur','Mme' => 'Madame', 'Mll' => 'Mademoiselle'],$beneficiaire->civilite,['class' => 'selectpicker',] ) !!}
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-3">
                        {!! Form::label('datenaiss', 'date de naissance') !!}
                            <div class='input-group date' id='datepicker_datenaiss'>
                                    {!! Form::text('datenaiss', $beneficiaire->datenaiss, ['placeholder' => 'Date de naissance', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_datenaiss').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                    </div>
                    <div class="col-md-4">
                        {!! Form::label('lieunaiss', 'Lieu de naissance') !!}
                        {!! Form::text('lieunaiss', null, ['placeholder' => 'Lieu de naissance', 'class' => 'form-control text-uppercase']) !!}
                    </div>
                </div>

                <div class='form-group'>
                    <div class="col-md-3">
                    {!! Form::label('statut', 'Statut') !!}
                    <br/>
                    {!! Form::select('statut',$liste_benefstatut,$beneficiaire->statut,['class' => 'selectpicker','data-width' => "100%",]) !!}
                    </div>

                    <div class='col-md-2'>
                        {!! Form::label('n_all', 'Certificat de vie') !!}
                        {!! Form::text('n_all', null, ['placeholder' => 'Certificat de vie', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-md-3">
                        {!! Form::label('date_deces', 'date de décès') !!}
                            <div class='input-group date' id='datepicker_date_deces'>
                                    {!! Form::text('date_deces', $beneficiaire->date_deces, ['placeholder' => 'Date de décès', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_date_deces').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                    </div>

                </div>

                <div class='form-group'>
                    <div class="col-md-3">
                        {!! Form::label('created_at', 'Date de création') !!}
                        {!! Form::text('created_at', null, ['class' => 'form-control','readonly'=>'true']) !!}
                    </div>
                
                    <div class="col-md-3">
                        {!! Form::label('date_pi', 'Date 1ère immatriculation') !!}
                            <div class='input-group date' id='datepicker_datepi'>
                                    {!! Form::text('date_pi', $beneficiaire->date_pi, ['placeholder' => 'Date de première immatriculation', 'class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_datepi').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                    </div>
                </div>
                <div class="form-group" > 
                    <div class='col-md-2 '>
                        {!! Form::label('verrou', 'Verrou') !!}
                        {!! Form::checkbox('verrou', null, ['class' => 'form-control']) !!}
                    </div>
                </div>

                <div class='form-group'>
                    <div class="col-md-8 " >
                    {!! Form::label('obs', 'Observations') !!}
                    {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
                    </div>
                </div>
            </div>
        </div>

        <!-- ------------------------------------- ONGLET ADRESSE ------------------------------- -->
        <div class="tab-pane col-md-9 bg-info" id="adresse">
            <div class="form-group"> 
                <div class='col-md-8'>
                    {!! Form::label('adresse', 'Adresse') !!}
                    {!! Form::textarea('adresse', null, ['placeholder' => 'ADRESSE', 'class' => 'form-control', 'rows'=>'2']) !!}
                </div>
            </div>

            <div class="form-group"> 
                <div class='col-md-2'>
                    {!! Form::label('code_postal', 'Code postal') !!}
                    {!!Form::text('code_postal', null, ['placeholder' => 'CODE POSTAL', 'class' => 'form-control']) !!}
                </div>

                <div class='col-md-3'>
                    {!! Form::label('district', 'District - Zone') !!}
                    <br/>
                    {!! 
                    Form::select(
                        'district',
                        App\Models\MyApp::DISTRICTS2,
                        
                        $beneficiaire->district,
                        [
                            'class' => 'selectpicker','data-width' => "100%",
                        ]
                    ) 
                !!}
                </div>

                <div class='col-md-3'>
                    {!! Form::label('ile', 'Ile/Région') !!}
                    <br/>
                        {!! 
                        Form::select(
                            'ile',
                            App\Models\MyApp::ILES2,
                            $beneficiaire->ile,
                            [
                                'class' => 'selectpicker','data-width' => "100%",
                            ]
                        )
                    !!}                
                </div>
            </div>

            <div class="form-group">
                <div class="col-md-6">
                    {!! Form::label('email', 'Email') !!}
                    {!! Form::email('email', null, ['placeholder' => 'EMAIL', 'class' => 'form-control'] )!!}
                </div>
            </div>

            <div class="form-group"> 
                <div class='col-md-3'>
                    {!! Form::label('tel', 'Téléphone') !!}
                    {!! Form::text('tel', null, ['placeholder' => 'TELEPHONE', 'class' => 'form-control']) !!}
                </div>

                <div class='col-md-3'>
                    {!! Form::label('fax', 'Fax') !!}
                    {!! Form::text('fax', null, ['placeholder' => 'FAX', 'class' => 'form-control']) !!}
                </div>
            </div>
        </div>

        <!-- ------------------------------------- ONGLET FAMILLE ------------------------------- -->
        <div class="tab-pane" id="famille">
            <div class="form-group">
                <div class="col-md-6">
                    {!! Form::label('nom_conjoint', 'Conjoint') !!}
                    {!! Form::hidden('conjoint', null, ['id' => 'conjoint']) !!}

                    <div class="input-group">
                        <span class="input-group-addon"  id='conjoint_addon'>
                            {!! str_pad($beneficiaire->conjoint, 6, "0", STR_PAD_LEFT) !!}
                        </span>
                        <input type="text" class="form-control" name="nom_conjoint" id="nom_conjoint" 
                            value='{!! $beneficiaire->nom_conjoint !!}' 
                            placeholder="Conjoint" 
                            />
                    </div>
                </div>
            </div>

            <div class="form-group"> 
                <div class='col-md-2'>
                    {!! Form::label('nb_enf', "Nombre d'enfants") !!}
                    {!! Form::text('nb_enf', null, ['placeholder' => "Nombre d'enfants", 'class' => 'form-control']) !!}
                </div>

                <div class='col-md-2'>
                    {!! Form::label('nb_enf_tot', "Nombre d'enfants total") !!}
                    {!! Form::text('nb_enf_tot', null, ['placeholder' => "Nombre d'enfants total", 'class' => 'form-control']) !!}
                </div>
            </div> 

            <div class="row">
                <div class="col-xs-8 " >
                    <h4>Enfants</h4>
                    <table id="_table" class="table table-condensed table-striped table-bordered" width="90%" >
                        <thead>
                            <tr>
                                <th width='1%'>Id</th>
                                <th width='20%'>Nom</th>
                                <th width='10%'>Prenom</th>
                                <th width='5%'>Date de naissance</th>
                                <th width='1%'>Sexe</th>
                                <th width='20%'>Certificat</th>
                                <th  width='220px'>
                                    @if($user->can("ENF_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="{!! url('enfants_create_avec_benef/'.$beneficiaire->id) !!}" 
                                        id='btn_ajout_enfant' 
                                        class="various fancybox.iframe btn btn-success" target="_blank">Ajouter un enfant</a>
                                    @endif
                                    
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($enfants as $enfant)
                            <tr>
                                <td>{!! str_pad($enfant->id, 6, "0", STR_PAD_LEFT) !!}</td>
                                <td nowrap>{!! $enfant->nom !!}</td>
                                <td nowrap>{!! $enfant->prenom !!}</td>
                                <td nowrap>{!! $enfant->datenais !!}</td>
                                <td nowrap>{!! $enfant->sexe !!}</td>
                                <td nowrap>{!! $enfant->certif !!}</td>
                                <td nowrap>
                                    <a href="{!! url('tiers/enfants/'.$enfant->id) !!}" 
                                        class="various fancybox.iframe btn btn-warning" 
                                        id='btn_visu_enfant' 
                                        style="margin-right: 3px;">Consulter</a>

                                @if($user->can("ENF_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('enfants_edit_avec_benef/'.$enfant->id.'/'.$beneficiaire->id) !!}" 
                                        id='btn_maj_enfant' class="various fancybox.iframe btn btn-primary" 
                                        style="margin-right: 3px;">Modifier</a>    
                                @endif 


                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                 </div> 
             </div> 
        </div>


        <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->
        <div class="tab-pane" id="banque">
            <div class="form-group">
                <div class="col-md-8">
                    {!! Form::label('employeur', 'Employeur :' ) !!}   
                    {!! Form::hidden('sonum', $beneficiaire->sonum, ['id' => 'sonum']) !!}
                    <div class="input-group"  id="ref_employeur">
                        <span class="input-group-addon"  name="employeur_addon" id='employeur_addon'>  
                        {!! $beneficiaire->sonum !!}</span>
                        <input type="text" class="form-control" 
                        name="employeur_nom" id="employeur_nom" 
                            value='{!! $beneficiaire->employeur !!}' 
                            placeholder="Employeur" 
                            />
                    </div>
                    <script>
                        $(function() {        
                           $("#employeur_nom").autocomplete({
                                source: "{!! route('autocomplete_employeur') !!}",
                                minLength: 1,
                                select: function(event, ui) {
                                    $('#sonum').val(ui.item.id);
                                    $('#employeur_addon').html(ui.item.id);
                                },
                                change: function( event, ui ) {
                                    var id_nom=ui.item.value.trim();
                                    var nom;
                                    if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                                    $('#employeur_nom').val(nom);
                                    $('#employeur_addon').html(ui.item.id);
                                    $('#sonum').val(ui.item.id);
                                }
                            }); 
                           return;
                        });
                    </script>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-5">
                    {!! Form::label('banque_id', 'Banque') !!}
                    <div class="input-group">
                        <div class="input-group-addon" id="ref_banque">{!! (isset($beneficiaire_banque->banque_id)?$beneficiaire_banque->banque_id:"") !!}</div>
                            {!! Form::select(
                                'banque_id',
                                array(""=>"")+DB::table('banques')->orderby(db::raw("nom"))->pluck('nom', 'id')->toArray(),
                                (isset($beneficiaire_banque->banque_id)?$beneficiaire_banque->banque_id:""),[
                                    'class' => 'selectpicker',
                                    'data-width' => "100%",
                                    'onchange' => "$('#ref_banque').html($('#banque_id').val());"
                                ]) 
                            !!}
                        </div>
                    </div>
                </div>
                <!--
                <div class="form-group">
                    <div class="col-md-3">
                        {!! Form::label('compte', 'Ancien Compte') !!}
                        {!! Form::text('compte', null, ['readonly' => 'true', 'class' => 'form-control'])!!}
                    </div>
                </div>
            -->

            <div class="form-group bg-info alert">
                <div class="col-md-12 ">
                {!! Form::label('IBAN', 'IBAN') !!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN_pays', 'Pays') !!}
                    {!! Form::text('IBAN_pays',( isset($beneficiaire_banque->IBAN_pays)?$beneficiaire_banque->IBAN_pays:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN', 'Clé IBAN') !!}
                    {!! Form::text('IBAN_cle', (isset($beneficiaire_banque->IBAN_cle)?$beneficiaire_banque->IBAN_cle:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
                <div class="col-md-2">
                    {!! Form::label('IBAN_banque', 'Banque') !!}
                    {!! Form::text('IBAN_banque', (isset($beneficiaire_banque->IBAN_banque)?$beneficiaire_banque->IBAN_banque:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
                <div class="col-md-2">
                    {!! Form::label('IBAN_guichet', 'Guichet') !!}
                    {!! Form::text('IBAN_guichet',(isset($beneficiaire_banque->IBAN_guichet)?$beneficiaire_banque->IBAN_guichet:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
                <div class="col-md-3">
                    {!! Form::label('IBAN_compte', 'Numéro de compte') !!}
                    {!! Form::text('IBAN_compte', (isset($beneficiaire_banque->IBAN_compte)?$beneficiaire_banque->IBAN_compte:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
                <div class="col-md-1">
                    {!! Form::label('IBAN_clerib', 'Clé RIb') !!}
                    {!! Form::text('IBAN_clerib', (isset($beneficiaire_banque->IBAN_clerib)?$beneficiaire_banque->IBAN_clerib:""), ['placeholder' => '', 
                        'class' => 'form-control text-uppercase'])!!}
                </div>
            </div>

            </div>

        <!-- ------------------------------------- ONGLET ALLOCATION ------------------------------- -->
        <div class="tab-pane" id="allocation">      
            <div class="form-group">
                <div class="col-md-2">
                    {!! Form::label('nb_enf', 'Nb enfants') !!}
                    {!! Form::text('nb_enf', null, ['placeholder' => 'Nombre d\'enfants', 'class' => 'form-control'])!!}
                </div>
            </div>
            {!! Form::label('montants_allocations', 'Montants') !!}
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-success">
                        <div class="input-group-addon" style="width:100px">Montant allocation</div>
                        {!! Form::text('mt_allloc', null, ['placeholder' => 'Montant', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-warning">
                        <div class="input-group-addon">Montant calculé</div>
                        {!! Form::text('mt_calc', null, ['placeholder' => 'Montant calculé', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-error">
                        <div class="input-group-addon ">Montant rappel</div>
                        {!! Form::text('rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-8">
                    {!! Form::label('obs_vers', 'Observations') !!}
                    {!!  Form::textarea('obs_vers', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
                </div>
             </div>
        </div>

        <!-- ------------------------------------- ONGLET SALAIRES ------------------------------- -->
        @php
            $t_mois=["jan"=>"01","fev"=>"02","mar"=>"03","avr"=>"04","mai"=>"05",
                "jun"=>"06","jui"=>"07","aou"=>"08","sep"=>"09","oct"=>"10","nov"=>"11","dec"=>"12"];
        @endphp
        <div class="tab-pane" id="salaires">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="table-responsive">
                            <table id="_table_longue" class="table table-condensed table-striped table-bordered">
                                <thead>
                                    <tr>

                                        <th width='1%'>N°</th>
                                        <th width='20%'>Employeur</th>
                                        <th width='1%'>Année</th>
                                        @foreach($t_mois as $mois=>$nummois)
                                            <th width='5%'  align='center'>{!! $mois !!}</th>
                                        @endforeach
                                        <th width='5%'>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($salaires as $salaire)
                                    <tr>
                                        <td>{!! $salaire->id !!}</td>
                                        <td nowrap>{!! $salaire->employeur_nom !!}</td>
                                        <td nowrap>{!! $salaire->annee !!}</td>
                                        @foreach($t_mois as $mois=>$nummois)
                                            @php
                                                $class='success';$style='';
                                                $class=isset($t_salaires_ref[$salaire->annee.'-'.$nummois])?$class:'';
                                                if($salaire->getIsHorsPlafond($mois)) $style="color:red;";
                                                $montant_salaire=$salaire->{$mois};
                                                if($salaire->getSuspendu($mois)) {
                                                    $style.="background-color:darkgrey;font-size:.9em";
                                                    $montant_salaire="SUSPENDU";
                                                }
                                            @endphp
                                            <td nowrap class='{!! $class !!}' align='right' style='{!! $style !!}'>
                                                {!! $montant_salaire !!}
                                            </td>
                                        @endforeach
                                        <td nowrap align='right'></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                </div>
            </div>
            @if( ($beneficiaire->sonum>0) && ($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR") ) )
             <div class="col-md-10 col-md-offset-5">
                <h4><a href="{!! url('recouvrement/salaire_annee/'.$beneficiaire->sonum.'/'.$beneficiaire->id) !!}" 
                    class="btn btn-success"
                    target="_blank">Gestion des Salaires</a></h4>
            </div> 
            @endif 
         </div>

        <!-- ------------------------------------- ONGLET VERSEMENTS ------------------------------- -->
        <div class="tab-pane" id="versements">
            <div class="form-group">
                <div class="col-md-6">
                    @if(count($versements)>0)
                    <div class="table-responsive">
                        <table id="_table_vers" style="width:100%" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th width='10%'>Montant</th>
                                    <th width='1%' >Date</th>
                                    <th width='10%'>Banque</th> 
                                    <th width='10%'>Compte</th>
                                    <th width='5%'>Type</th>
                                    <th >Observations</th>
                                </tr>
                            </thead>
                 
                            <tbody>
                                @foreach ($versements as $versement)
                                <tr>
                                    <td>{!! $versement->id !!}</td>
                                    <td>{!! $versement->montant !!}</td>
                                    <td>{!! $versement->date !!}</td>
                                    <td>{!! $versement->banque_nom !!}</td>
                                    <td>{!! $versement->compte !!}</td>
                                    <td>{!! $versement->type !!}</td>
                                    <td>{!! $versement->obervations !!}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                        <h3>Aucun versements à afficher</h3>
                    @endif
                </div>

                <div class="col-md-4" style="padding-top:20px">
                    <a href="{!! url('versements_historique/'.$beneficiaire->id) !!}" 
                    id='btn_ajout_enfant' 
                    class="box_versement fancybox.iframe btn btn-success" 
                    target="_blank">Consulter l'historique des versements</a>
                </div>
            </div>
         </div>

        <!-- ------------------------------------- ONGLET RETRAITE ------------------------------- -->

        <div class="tab-pane" id="retraite">
            <div class="form-group">
                <div class='col-md-2'>
                    {!! Form::label('ret_numdec', 'Numéro de décision') !!}
                    {!! Form::text('ret_numdec', null, ['placeholder' => 'Numéro de décision', 'class' => 'form-control'])!!}
                </div>

                <div class="col-md-3">
                    {!! Form::label('ret_dateed', 'Date') !!}
                    <div class='input-group date' id='datepicker_ret_dateed'>
                            {!! Form::text('ret_dateed', $beneficiaire->date_med, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_ret_dateed').datepicker({
                                    format: "dd/mm/yyyy",language: "fr",autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>

                <div class='col-md-2'>
                    {!! Form::label('ret_type', 'Type de retraite') !!}
                    <br/>
                        {!! 
                        Form::select(
                            'ret_type',
                            ['' => 'A définir' , 'PRE' =>'PRE' , 'PRV' => 'PRV', 'PAV' => 'PAV', 'PRA' => 'PRA', 'AUT' => 'Autre'],
                           $beneficiaire->ret_type,
                            [
                                'class' => 'selectpicker',
                            ]
                        )
                    !!}                
                </div>
            </div>
            {!! Form::label('montants_retraite', 'Montants RETRAITE') !!}
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-success">
                        <div class="input-group-addon ">Montant retraite</div>
                        {!! Form::text('ret_montant', null, ['placeholder' => 'Montant retraite', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-error">
                        <div class="input-group-addon ">Montant rappel</div>
                        {!! Form::text('ret_rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control'])!!}
                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>

            <hr>
            <fieldset>
                {!! Form::label('montants_csr', 'Montants CSR') !!}
                <div class="form-group">
                    <div class="col-md-4">
                        <div class="input-group has-success">
                            <div class="input-group-addon ">Montant CSR (dernier versement)</div>
                            {!! Form::text('csr_montant', null, ['placeholder' => 'Montant CSR', 'class' => 'text-right form-control',
                            'readonly' => 'true',])!!}
                            <div class="input-group-addon">CFP</div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-4">
                        <div class="input-group has-error">
                            <div class="input-group-addon ">Montant rappel CSR</div>
                            {!! Form::text('csr_rappel', null, ['placeholder' => 'Montant rappel CSR', 'class' => 'text-right form-control'])!!}
                            <div class="input-group-addon">CFP</div>
                        </div>
                    </div>
                </div>
            </fieldset>
        </div>

     </div>    

    <div class="col-sm-9">
        <div class='form-group'>
            {!! Form::submit('Enregistrer les modifications', 
                ['class' => 'btn btn-primary',
                'onclick'=>'$("#mode_return").val(false);']) !!}
        </div>
    </div>

    {!! Form::close() !!}
 
</div>
@stop


@section('scripts')
    {!! Html::script('js/magicsuggest.js') !!}
    {!! Html::script('js/jquery.fancybox.js') !!}
    
    <!-- {!! Html::script('js/jquery.dataTables.editable.js') !!}

    <!-- Datatable  -->
    {!! Html::script('js/jquery.dataTables.js'); !!}
    {!! Html::script('js/dataTables.bootstrap.js'); !!}


    <!-- Datatable Button --> 
    {!! Html::script('js/dataTables.buttons.js'); !!}
    {!! Html::script('js/buttons.bootstrap.js'); !!}
    {!! Html::script('js/buttons.html5.js'); !!}
    {!! Html::script('js/buttons.print.js'); !!}
    {!! Html::script('js/jszip.min.js'); !!}
    {!! Html::script('js/pdfmake.min.js'); !!}
    {!! Html::script('js/vfs_fonts.js'); !!}
    {!! Html::script('js/buttons.colVis.min.js'); !!}

    {!! Html::script('js/moment.min.js'); !!}
    {!! Html::script('js/datetime-moment.js'); !!}


    <script type="text/javascript">
    $(document).ready(function() {

         $('#_table tbody').on( 'click', 'tr', function () {
            $(this).toggleClass('selected');
        } );

        function fnGetSelected( oTableLocal )
        {
            var aReturn = new Array();
            var rowLength = oTableLocal.rows('.selected').data().length;
            //loops through rows    
            for (i = 0; i < rowLength; i++){
               //gets cells of current row
               var cellVal = oTableLocal.rows('.selected').data()[i][0];
               aReturn.push(cellVal);
            }
            return aReturn;
        }

        $(".box_versement").fancybox({
            fitToView   : true,
            width       : '85%',
            height      : '70%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
        
        $(".various").fancybox({
            maxWidth    : 800,
            maxHeight   : 600,
            fitToView   : false,
            width       : '70%',
            height      : '70%',
            autoSize    : false,
            autoScale   : false,
            closeClick  : false,
            openEffect  : 'none',
            closeEffect : 'none'
        });


    });
    </script>
@stop


@section('scripts_end')
<script>
  $.fn.dataTable.moment('D/M/YYYY');

  var table =$('#_table_longue').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    true,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      oLanguage: {
          "sZeroRecords": "Aucune ligne",
          "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
          "sInfoEmpty": "Showing 0 to 0 of 0 records",
          "sInfoFiltered": "(sur un total de _MAX_ lignes)",
          "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
              ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
              "sSearch":"Chercher ",
          buttons: {
              colvis: 'Colonnes',
              copy: 'Copier',print: 'Imprimer',
              copyTitle: 'Ajouté au presse-papiers',
              copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
              copySuccess: {
                  _: '%d lignes copiées',
                  1: '1 ligne copiée'
                  }
              }
          },
           dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'>B>" +
          "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],
      } );

    //enfants
    var table =$('#_table').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    false,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      dom: "<'row'<'col-sm-4 text-left'><'col-sm-4'><'col-sm-6 text-right'>>" +
          "<'row'<'col-sm-12't>>" +"<'row'<'col-sm-5'i><'col-sm-7'>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],
      } );
    

        //Versements
    var table =$('#_table_vers').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    false,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      dom: "<'row'<'col-sm-4 text-left'><'col-sm-4'><'col-sm-6 text-right'>>" +
          "<'row'<'col-sm-12't>>" +"<'row'<'col-sm-5'i><'col-sm-7'>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],
      } );
</script>


<script type="text/javascript">
    $(function() {
        $("#nom_conjoint").autocomplete({
            source: "{!! url('auto_conjoint') !!}",
            minLength: 2,
            select: function(event, ui) {
                $('#nom_conjoint').val(ui.item.value);
                $('#conjoint').val(ui.item.id);
                $('#conjoint_addon').html(ui.item.id);
            },
            close: function(event, ui) {
                
            }
        });    
    });
</script>
@stop
