@include('forms.fbncheader')
@include('forms.fdatatables')


{!! Html::style('css/bootstrap-select.min.css') !!}
{!! Html::style('css/datepicker3.css') !!}

<div style="background-color:{!! $user->getIconeTypeTab($benef_type)['color'] !!};"  class="col-lg-max col-lg-offset-1 container-fluid">

<div style="padding-left:0px" class="col-lg-12">
     <div class="row" style="">   
        <div class="col-xs-1" style="padding-left:0px;">
           {!! Html::image("img/".$user->getIconeTypeTab($benef_type)["icone"], 
                "Retraite", 
                array( 'width'=>'100%',
                    "style"=>"padding:4px" ))
                 
            !!} 
        </div>
        <div class="col-xs-3" style="padding-left:0px;">
            <h2 style="margin-top:2px;">Bénéficiaires </h2>
            {!! Form::select(
                'benef_type',$liste_beneftype,$benef_type,
                ['id' => 'benef_type2','class' => 'form-control selectpicker',
                    'data-width' => '100%',
                    'style' => 'height:50px;font-size:24px;font-weight:bold;
                    background-color: rgba(255,255,255,.5);']
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#benef_type2').on('change', function() {
                        location.href="{!! url('/tiers/beneficiaires/limit') !!}/"+$('#benef_type2').val();
                    });
                });
            </script>
        </div>

    </div>
</div>

<div class='col-lg-max' style="padding-top:5px">
    <div class="">
        <table id="_table" style="background-color:white" 
            class="table table-striped table-bordered table-hover" width="100%" 
            >
            <thead>
                <tr>
                    <th width='1%'>Id</th>
                    <th width='30%'>Nom</th>
                    <th width='5%'>Date de naissance</th>
                    <th width='1%'>NbEnf.</th>
                    <th width='30%'>Conjoint</th>
                    <th width='30%'>Employeur</th> 
                    <th width='30%'>Montant Ret.</th> 
                    <th width='30%'>Montant CSR</th> 
                    <th width='1%'>Statut</th>
                    <th width='1%'>Création</th>
                    @if($benef_type=="A")
                    <th width='1%'>AyantDroit</th>
                     @endif
                    @if($benef_type=="RET")
                        <th width='1%'>TypeRet</th>
                    @endif
                    @if( $user->can("BEN_VISU") || $user->can("BEN_MAJ") ||
                        $user->can("BEN_SUP") || $user->HasRole("ADMINISTRATEUR") )
                    <th width='1%'>&nbsp;</th>
                    @endif 
                </tr>
            </thead>
 
            <tbody>
                @foreach ($beneficiaires as $beneficiaire)
                <tr>
                    <td>{!! str_pad($beneficiaire->id, 6, "0", STR_PAD_LEFT) !!}</td>
                    <td>
                        <a href="{!! url('tiers/beneficiaires_statut/'.$beneficiaire->id.'/'.$benef_type) !!}">
                            {!! $beneficiaire->nom_complet !!}
                        </a>
                    </td>
                    <td>{!! $beneficiaire->datenaiss !!}</td>
                    <td align="center">{!! $beneficiaire->nb_enf."/".$beneficiaire->nb_enf_tot !!}</td>
                    <td>{!! $beneficiaire->nom_conjoint !!}</td>
                    <td>{!! $beneficiaire->employeur_court !!}</td>  
                    <td align="center">{!! $beneficiaire->ret_montant !!}</td>
                    <td align="center">{!! $beneficiaire->csr_montant !!}</td>  
                    <td align="center">{!! $beneficiaire->statut !!}</td>
                    <td align="center">{!! $beneficiaire->created_at !!}</td>
                    @if($benef_type=="A")
                    <td align="center">{!! ($beneficiaire->ayantdroit)?"OUI":"NON" !!}</td>
                    @endif
                    @if($benef_type=="RET")
                        <td align="center">{!! $beneficiaire->ret_type !!}</td>
                    @endif
                    @if( $user->can("BEN_VISU") || $user->can("BEN_MAJ") ||
                        $user->can("BEN_SUP") || $user->HasRole("ADMINISTRATEUR") )
                    <td>
                        <!--
                        @if($user->can("BEN_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('tiers/beneficiaires_statut/'.$beneficiaire->id.'/'.$benef_type) !!}" class="btn btn-warning pull-left" style="margin-right: 3px;">Consulter</a>
                        @endif 
                    -->
                        @if($user->can("BEN_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('tiers/beneficiaires_statut/'.$beneficiaire->id.'/'.$benef_type.'/edit') !!}" 
                                class="btn btn-info pull-left" style="margin-right: 3px;">
                                Modifier
                            </a>
                        @endif 
                        @if($user->can("BEN_SUP") || $user->HasRole("ADMINISTRATEUR")) 
                            @if($beneficiaire->has_cascade)  
                            {!! Form::open(['url' => '/tiers/beneficiaires/' . $beneficiaire->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                            {!! Form::close() !!}
                            @endif 
                        @endif 
                    </td>
                    @endif 
                </tr>
                @endforeach
            </tbody>
        </table>
        
        <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.document.location = $(this).data("href");
            });
        });
        </script>
    </div>
@if($user->can("BEN_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('tiers/beneficiaires/create?lst='.$benef_type) !!}" class="btn btn-success">Ajouter un bénéficiaire</a></h4>
    </div> 
@endif
</div>

</div>

</body></html>




@include('forms.fdatatables_script')